//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#ifndef PLAYFRAME_H
#define PLAYFRAME_H


// Include dependency
#include "baseframe.h"
#include "sprite.h"
#include <list>
using namespace std;


// Playframe class
class PlayFrame: public BaseFrame {
private:
	// Variables
	float SliderSpeed;
	int TimeToRessPlayer;

	// Bitmaps
	BITMAP *ColorSlider;
	BITMAP *SliderCursor;
	BITMAP *StatusBar;

	// Functions
	int GetColorFromSlider (float pos);

public:
	list<Sprite*> Sprites;
	int MouseMoveX,MouseMoveY;

	class EnemyWave *Wave[10];
	int CurrentWave;
	int NextWaveTimer;
	bool HasWave;
	bool WaveActive;
	bool pause;

	bool GameWin;
	bool GameOver;
	int NamePos;
	char PlayerName[32];

	float SliderPos;
	bool JustShot;
	int ScoreToAdd;

	class PlayerClass *Player;
	int PlayerScore;
	int PlayerLives;

	bool Dialogue;
	int CurrentDialogue;
	int DialogueLines;
	int DialoguePerson[2];
	int DialogueSpeaker;
	float DialoguePos;
	char DialogueText[4096];
	int DialogueLine;

	PlayFrame();
	~PlayFrame();

	void SetDialogueText(const char *text,int speaker);
	void GetNextDialogueLine();

	int CountSprites(SpriteType type);
	void DamageArea(int hue,int damage,int x,int y,int radius);
	void AddSprite(Sprite *target);
	void AddScore(int ammount);
	int GetCurrentSliderColor(float s,float v);
	bool Update();
	void Render();
};


#endif
