//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#include <allegro.h>
#define ALFONT_DLL
#include <alfont.h>
#include <fblend.h>
#include "kernel.h"
#include "data.h"
#include "people.h"
#include "input.h"
#include "playership.h"
#include "audio.h"
#include "introframe.h"


// Constructor
IntroFrame::IntroFrame() {
	char path[512];
	Data.MakePath(path,"img/cellosoft.gif");
	cellosoft = load_bitmap(path,NULL);

	step = 0;
	timer = 0;
	objectfade = 0;
}


// Destructor
IntroFrame::~IntroFrame() {
	destroy_bitmap(cellosoft);
}


// Update
bool IntroFrame::Update() {
	// Escape
	if (key[KEY_ESC] || key[KEY_ENTER]) {
		Switch(2);
		Fade=250;
	}

	// Timer update
	if (step == 2) timer++;
	else timer+=2;

	if (timer > 100 && timer <= 355) objectfade = timer - 100;
	if (timer > 500 && timer <= 755) objectfade = 755 - timer;
	if (timer > 755) {
		timer = 0;
		step++;
	}
	if (step == 3) Switch(2);

	// OK
	return BaseFrame::Update();
}


// Render
void IntroFrame::Render() {
	// Clear background
	clear_bitmap(Kernel.BackBuffer);
	int color = makecol(102,146,225);

	switch (step) {
		case 0:
			Kernel.SetDirty(165,85,310,310);
			fblend_trans(cellosoft,Kernel.BackBuffer,165,85,objectfade);
			break;
		case 1:
			Kernel.SetDirty(100,220,440,50);
			alfont_textout_centre_aa_ex(Kernel.BackBuffer, Data.Font[0], "Cellosoft presents", 320, 220, color, -1);
			alfont_textout_centre_aa_ex(Kernel.BackBuffer, Data.Font[0], "A game for Allegro TINS'05 competition", 320, 240, color, -1);
			fblend_rect_trans(Kernel.BackBuffer,100,220,540,260,makecol(0,0,0),255-objectfade);
			break;
		case 2:
			Kernel.SetDirty(120,170,400,140);
			fblend_trans(Data.LogoBmp,Kernel.BackBuffer,120,170,objectfade);
			break;
	}
}
