//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#include <allegro.h>
#define ALFONT_DLL
#include <alfont.h>
#include <string.h>
#include "titleframe.h"
#include "kernel.h"
#include "data.h"
#include "input.h"
#include "audio.h"
#include "highscores.h"


// Constructor
TitleFrame::TitleFrame() {
	// Create background
	background = create_bitmap(screen->w,screen->h);
	int color;
	for (int y=background->h;--y>=0;) {
		color = Data.HSVtoRGB(216,0.67,float(y)/2000.0+0.2);
		for (int x=background->w;--x>=0;) {
			putpixel(background,x,y,color);
		}
	}

	// Logo on bg
	draw_sprite(background,Data.LogoBmp,40,40);

	// Set MIDI
	Audio.SetMidi(0);

	// Variables
	SetKey = false;
	CreditsPos = -200;
	RenderAgain = true;
	option = 0;
	mode = 0;
	strcpy(Credits,
		"\"Lord of the Stars\" Credits \n "
		"A TINS'05 entry game. \n "
		"* \n "
		"Game Design \n "
		"* Rodrigo Braz Monteiro \n "
		"* \n "
		"Core Programming \n "
		"* Rodrigo Braz Monteiro \n "
		"* \n "
		"Additional programming \n "
		"* Justt \n "
		"* \n "
		"Graphics and Sprites \n "
		"* Rodrigo Braz Monteiro \n "
		"* \n "
		"Dialogue scripts \n "
		"* Rodrigo Braz Monteiro \n "
		"* nmap \n "
		"* \n "
		"Sound and Music \n "
		"* Various unknown artists \n "
		"* \n "
		"Thanks to \n "
		"* Justt \n "
		"* nmap \n "
		"* Marcello Bastea-Forte \n "
		"* Oblisk \n "
		"* polar \n "
		"* \n "
		"Libraries used \n "
		"* Allegro \n "
		"* FBlend \n "
		"* AlGif \n "
		"* AlFont \n "
		"* \n "
		"Developed using Microsoft Visual Studio .NET 2003"
		);
}


// Destructor
TitleFrame::~TitleFrame() {
	if (background) destroy_bitmap(background);
	background = NULL;
}


// Update
bool TitleFrame::Update() {
	// Change option
	int prevOption = option;

	if (Input.KeyDown[KEY_DOWN]) option++;
	if (Input.KeyDown[KEY_UP]) option--;

	switch (mode) {
		case 0:
			if (Input.KeyDown[KEY_ESC]) {
				Audio.SetMidi(-1);
				Switch(-1);
			}
			if (option > 2) option = 0;
			if (option < 0) option = 2;
			break;

		case 1:
			if (option > 11) option = 0;
			if (option < 0) option = 11;
			if (Input.KeyDown[KEY_ESC]) {
				mode = 0;
				option = 1;
				RenderAgain = true;
			}
			break;

		case 2:
			option = 0;
			if (Input.KeyDown[KEY_ESC]) {
				mode = 0;
				option = 2;
				RenderAgain = true;
			}
			break;
	}

	// Changed option
	if (option != prevOption) {
		RenderAgain = true;
		play_sample(Data.Sample[5],255,128,2000,0);
	}

	// Set key
	if (mode == 1 && SetKey) {
		SetKey = false;
		Data.GameKeys[option-2] = readkey() >> 8;
		Input.Update();
		//for (int i=0;i<KEY_MAX;i++) Input.KeyDown[i] = false;
	}

	// Root
	if (mode == 0) {
		// Go to screen
		if (Input.KeyDown[KEY_ENTER]) {
			switch(option) {
				case 0:
					Switch(0);
					break;
				case 1:
					mode = 1;
					option = 11;
					RenderAgain = true;
					break;
				case 2: 
					Audio.SetMidi(-1);
					Switch(-1);
					break;
			}
		}

		// Credits
		CreditsPos += 0.4;
		if ((int)CreditsPos > alfont_text_height(Data.Font[1])*CreditsLines) CreditsPos = -200;
	}

	else if (mode == 1) {
		if (Input.KeyDown[KEY_ENTER]) {
			switch(option) {
				case 0:
					if (Data.FullScreen == 1) Data.FullScreen = 0;
					else Data.FullScreen = 1;
					Kernel.SetGraphicsMode = true;
					break;
				case 1:
					if (Data.ColorDepth == 32) Data.ColorDepth = 16;
					else Data.ColorDepth = 32;
					break;
				case 2:
				case 3:
				case 4:
				case 5:
				case 6:
				case 7:
				case 8:
				case 9:
					Data.GameKeys[option-2] = 0;
					clear_keybuf();
					SetKey = true;
					break;
				case 10:
					play_sample(Data.Sample[8],255,128,1000,0);
					char path[512];
					Data.MakePath(path,"lots.cfg");
					set_config_file(path);
					set_config_int("controls","up",Data.GameKeys[0]);
					set_config_int("controls","down",Data.GameKeys[1]);
					set_config_int("controls","shoot",Data.GameKeys[2]);
					set_config_int("controls","colorleft",Data.GameKeys[3]);
					set_config_int("controls","colorright",Data.GameKeys[4]);
					set_config_int("controls","altup",Data.GameKeys[5]);
					set_config_int("controls","altdown",Data.GameKeys[6]);
					set_config_int("controls","pause",Data.GameKeys[7]);
					set_config_int("video","colordepth",Data.ColorDepth);
					set_config_int("video","fullscreen",Data.FullScreen);
					break;
				case 11:
					mode = 0;
					option = 1;
					RenderAgain = true;
					break;
			}
		}
	}

	// Update as base
	return BaseFrame::Update();
}


// Draw
void TitleFrame::Render() {
	// Draw options
	int curText = 0;
	int height = 30;
	int StartTextY = 50;
	int StartTextX = 590;
	int color;
	int colorSel = makecol(255,255,255);
	int colorNormal = makecol(102,146,225);

	// Background
	if (mode != 0 || RenderAgain == true || FadeMode != 0) {
		blit(background,Kernel.BackBuffer,0,0,0,0,screen->w,screen->h);
	}
	else blit(background,Kernel.BackBuffer,50,240,50,240,260,160);

	// Credits
	if (mode == 0) {
		rect(Kernel.BackBuffer, 50, 240, 309, 399, colorNormal);
		set_clip_rect(Kernel.BackBuffer,51,241,308,398);
		CreditsLines = Data.BreakText(Credits,55,245-(int)CreditsPos,250,Data.Font[1],colorNormal);
		set_clip_rect(Kernel.BackBuffer,0,0,screen->w-1,screen->h-1);
		Kernel.SetDirty(50,240,260,160);
	}

	// Check for need to render rest
	if (RenderAgain == false && FadeMode == 0 && mode == 0) {
		return;
	}
	RenderAgain = false;
	Kernel.RedrawAll = true;

	// High-scores
	if (mode == 0) {
		rect(Kernel.BackBuffer, 330, 240, 589, 399, colorNormal);
		int dy;
		dy = 244;
		for (int i=0;i<10;i++) {
			alfont_textprintf_right_aa_ex(Kernel.BackBuffer, Data.Font[1], 585, dy, colorNormal, -1, "%i", HighScores.score[i]);
			alfont_textprintf_aa_ex(Kernel.BackBuffer, Data.Font[1], 337, dy, colorNormal, -1, "%s", HighScores.name[i]);
			dy += 15;
		}
	}

	// Options Screen
	if (mode == 1) {
		rect(Kernel.BackBuffer, 50, 205, 589, 419, colorNormal);
		int dy = 209;

		// Fullscreen button
		if (option == 0) color = colorSel;
		else color = colorNormal;
		alfont_textprintf_right_aa_ex(Kernel.BackBuffer, Data.Font[1], 310, dy, color, -1, "Display:");
		if (Data.FullScreen == 1) alfont_textprintf_aa_ex(Kernel.BackBuffer, Data.Font[1], 330, dy, color, -1, "Fullscreen");
		else alfont_textprintf_aa_ex(Kernel.BackBuffer, Data.Font[1], 330, dy, color, -1, "Windowed");
		dy+=15;

		// Depth button
		if (option == 1) color = colorSel;
		else color = colorNormal;
		alfont_textprintf_right_aa_ex(Kernel.BackBuffer, Data.Font[1], 310, dy, color, -1, "Color Depth:");
		if (Data.ColorDepth == 32) alfont_textprintf_aa_ex(Kernel.BackBuffer, Data.Font[1], 330, dy, color, -1, "32 bit");
		else alfont_textprintf_aa_ex(Kernel.BackBuffer, Data.Font[1], 330, dy, color, -1, "16 bit");
		dy+=15;

		// Keys
		dy+=10;
		for (int i=0;i<8;i++) {
			if (i+2 == option) color = colorSel;
			else color = colorNormal;
			char curKeyName[64];
			switch (i) {
				case 0: strcpy(curKeyName,"Up:"); break;
				case 1: strcpy(curKeyName,"Down:"); break;
				case 2: strcpy(curKeyName,"Keyboard fire:"); break;
				case 3: strcpy(curKeyName,"Keyboard slide left:"); break;
				case 4: strcpy(curKeyName,"Keyboard slide right:"); break;
				case 5: strcpy(curKeyName,"Alternate up:"); break;
				case 6: strcpy(curKeyName,"Alternate down:"); break;
				case 7: strcpy(curKeyName,"Pause:"); break;
			}
			alfont_textprintf_right_aa_ex(Kernel.BackBuffer, Data.Font[1], 310, dy, color, -1, "%s", curKeyName);
			if (Data.GameKeys[i] != 0) alfont_textprintf_aa_ex(Kernel.BackBuffer, Data.Font[1], 330, dy, color, -1, "%s", scancode_to_name(Data.GameKeys[i]));
			else alfont_textprintf_aa_ex(Kernel.BackBuffer, Data.Font[1], 330, dy, color, -1, "<Press new key>");
			dy += 15;
		}

		// Save button
		dy+=10;
		if (option == 10) color = colorSel;
		else color = colorNormal;
		alfont_textout_centre_aa_ex(Kernel.BackBuffer, Data.Font[1], "Save to disk", 320, dy, color, -1);
		dy += 15;

		// Back button
		if (option == 11) color = colorSel;
		else color = colorNormal;
		alfont_textout_centre_aa_ex(Kernel.BackBuffer, Data.Font[1], "Back", 320, dy, color, -1);
		dy += 15;
	}

	// Root options
	int rootoption = option;
	if (mode == 1) rootoption = 1;
	if (mode == 2) rootoption = 2;

	// Option1
	if (rootoption == curText) color = colorSel;
	else color = colorNormal;
	alfont_textout_right_aa_ex(Kernel.BackBuffer, Data.Font[0], "Start Game", StartTextX, StartTextY + curText*height, color, -1);
	curText++;

	// Option2
	if (rootoption == curText) color = colorSel;
	else color = colorNormal;
	alfont_textout_right_aa_ex(Kernel.BackBuffer, Data.Font[0], "Options", StartTextX, StartTextY + curText*height, color, -1);
	curText++;

	// Option3
	//if (rootoption == curText) color = colorSel;
	//else color = colorNormal;
	//alfont_textout_right_aa_ex(Kernel.BackBuffer, Data.Font[0], "Help", StartTextX, StartTextY + curText*height, color, -1);
	//curText++;

	// Option4
	if (rootoption == curText) color = colorSel;
	else color = colorNormal;
	alfont_textout_right_aa_ex(Kernel.BackBuffer, Data.Font[0], "Exit", StartTextX, StartTextY + curText*height, color, -1);
	curText++;

	// Draw copyright
	textout_centre_ex(Kernel.BackBuffer, font, "\"The Lord of the Stars\" v1.0 - Copyright (c) 2005 - Rodrigo Braz Monteiro.",320,440,colorNormal,-1);
	textout_centre_ex(Kernel.BackBuffer, font, "Source distributed under GNU GPL. Written for TINS'05 Allegro contest.",320,450,colorNormal,-1);
	textout_centre_ex(Kernel.BackBuffer, font, "Cellosoft and its logo are (c) 1995-2005, Marcello Bastea-Forte.",320,460,colorNormal,-1);

	// Render as base
	BaseFrame::Render();
};
