//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#ifndef SPRITE_H
#define SPRITE_H

// Prototype
class Particle;

// Enum
enum SpriteType {
	SPRITE_TYPE_PLAYER,
	SPRITE_TYPE_TROLL,
	SPRITE_TYPE_ORC,
	SPRITE_TYPE_MINE,
	SPRITE_TYPE_URUK
};

// Class definition
class Sprite {
public:
	class PlayFrame *parent;
	struct BITMAP *bmp;

	SpriteType Type;

	float radius;
	float x,y;		// Position
	float vx,vy;	// Velocity
	float ax,ay;	// Acceleration
	int px,py;		// Pivot x,y
	int shootx,shooty;

	Sprite();
	void Destroy();
	Particle *CreateParticle();
	bool Collides(Sprite *target);
	bool Collides(int tx,int ty,int tr);
	virtual void Update();
	virtual void Draw();
};


#endif
