//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#include <allegro.h>
#define ALFONT_DLL
#include <alfont.h>
#include "selectframe.h"
#include "kernel.h"
#include "data.h"
#include "people.h"
#include "input.h"
#include "playership.h"
#include "audio.h"


// Constructor
SelectFrame::SelectFrame() {
	// Variables
	Kernel.RedrawAll = true;
	if (Data.pilot == 9) {
		CursorX = 4;
		CursorY = 1;
	}
	else {
		CursorX = (Data.pilot-1) % 4;
		CursorY = (Data.pilot-1) / 4;
	}

	// Create background
	background = create_bitmap(screen->w,screen->h);
	int color;
	for (int y=background->h;--y>=0;) {
		color = Data.HSVtoRGB(216,0.67,float(y)/2000.0+0.2);
		for (int x=background->w;--x>=0;) {
			putpixel(background,x,y,color);
		}
	}

	// Set MIDI
	Audio.SetMidi(0);
}


// Destructor
SelectFrame::~SelectFrame() {
	if (background) destroy_bitmap(background);
	background = NULL;
}


// Update
bool SelectFrame::Update() {
	// Move cursor
	if (Input.KeyDown[KEY_RIGHT]) CursorX++;
	if (Input.KeyDown[KEY_LEFT]) CursorX--;
	if (Input.KeyDown[KEY_DOWN]) CursorY++;
	if (Input.KeyDown[KEY_UP]) CursorY--;

	// Limits
	if (CursorY < 0) CursorY = 1;
	if (CursorY > 1) CursorY = 0;	
	int linelen = 3;
	if (CursorY == 1 && Data.Unlocked[4]) linelen = 4;
	if (CursorX < 0) CursorX = linelen;
	if (CursorX > linelen) CursorX = 0;

	// Set pilot
	int prevPilot = Data.pilot;
	Data.pilot = CursorX + CursorY*4 + 1;
	if (Data.pilot != prevPilot) {
		RenderAgain = true;
		play_sample(Data.Sample[5],255,128,2000,0);
	}

	// Select pilot
	if (Input.KeyDown[KEY_ENTER]) {
		if (CursorY == 1 && !Data.Unlocked[CursorX]) {
			//
		}
		else {
			Audio.SetMidi(-1);
			Switch(1);
		}
	}

	// Back
	if (Input.KeyDown[KEY_ESC]) {
		Switch(2);
	}

	// Fix for fade
	if (Fade == 5 && FadeMode != 0) RenderAgain = true;

	// Update as base
	return BaseFrame::Update();
}


// Draw
void SelectFrame::Render() {
	// Need render?
	if (RenderAgain == false && FadeMode == 0) {
		return;
	}
	RenderAgain = false;

	// Clear background
	//clear_bitmap(Kernel.BackBuffer);
	blit(background,Kernel.BackBuffer,0,0,0,0,screen->w,screen->h);

	// Draw portraits
	bool unlocked;
	int dx,dy,px,py;
	int starty = 80;
	People *cur;
	int portraits = 8;
	if (Data.Unlocked[4]) portraits = 9;
	for (int i=0;i<portraits;i++) {
		if (i == 8) {
			px = 4;
			py = 1;
		}
		else {
			px = i%4;
			py = i/4;
		}
		dx = px*100 + 130;
		dy = py*100 + starty;
		unlocked = true;
		if (i>=4 && !Data.Unlocked[i-4]) unlocked = false;
		if (Data.Person[i+1] && unlocked) cur = Data.Person[i+1];
		else cur = Data.Person[0];
		if (px == CursorX && py == CursorY) rectfill(Kernel.BackBuffer,dx-2,dy-2,dx+81,dy+81,cur->color);
		draw_sprite(Kernel.BackBuffer,cur->bmp,dx,dy);
		Kernel.SetDirty(dx-2,dy-2,84,84);
	}

	// Draw ask for pilot text
	int color = makecol(102,146,225);
	int colordark = makecol(13,30,62);
	alfont_textprintf_centre_aa_ex(Kernel.BackBuffer, Data.Font[0], screen->w/2, starty-45, color, -1, "Select your pilot:");
	Kernel.SetDirty(200,starty-45,starty-25,starty+230);

	// Get data
	unlocked = true;
	if (CursorY == 1 && !Data.Unlocked[CursorX]) unlocked = false;
	cur = Data.Person[CursorX+CursorY*4+1];
	if (!cur || !unlocked) cur = Data.Person[0];

	// Draw pilot name
	alfont_textprintf_centre_aa_ex(Kernel.BackBuffer, Data.Font[0], screen->w/2, starty+200, cur->color, -1, "Pilot: %s", cur->name);
	Kernel.SetDirty(200,starty+200,420,starty+230);

	// Draw ship data
	PlayerShip *curship = NULL;
	if (cur && unlocked) curship = Data.Ships[Data.pilot-1];
	starty += 250;
	int cury = starty;
	int len;

	// Draw Pic
	rect(Kernel.BackBuffer,130,starty,233,starty+79,color);
	rectfill(Kernel.BackBuffer,131,starty+1,232,starty+78,colordark);
	if (curship) draw_sprite(Kernel.BackBuffer,curship->bmp,156,starty+28);

	// Draw name
	rect(Kernel.BackBuffer,130,starty+81,233,starty+100,color);
	if (curship) alfont_textprintf_centre_aa_ex(Kernel.BackBuffer, Data.Font[1], 182, starty+81, color, -1, "%s", curship->name);

	// Bar1
	alfont_textout_right_aa_ex(Kernel.BackBuffer, Data.Font[1], "Damage:", 350, cury-1, color, -1);
	len = 0;
	if (curship) len = curship->Damage*150/20;
	if (len > 150) len = 150;
	rect(Kernel.BackBuffer,360,cury+2,510,cury+15,color);
	rectfill(Kernel.BackBuffer,360,cury+2,360+len,cury+15,color);
	cury+=20;

	// Bar2
	alfont_textout_right_aa_ex(Kernel.BackBuffer, Data.Font[1], "Life:", 350, cury-1, color, -1);
	len = 0;
	if (curship) len = (curship->MaxLife-70)*150/80;
	rect(Kernel.BackBuffer,360,cury+2,510,cury+15,color);
	rectfill(Kernel.BackBuffer,360,cury+2,360+len,cury+15,color);
	cury+=20;

	// Bar3
	alfont_textout_right_aa_ex(Kernel.BackBuffer, Data.Font[1], "Resistance:", 350, cury-1, color, -1);
	len = 0;
	if (curship) len = int((1-curship->DamageResistance)*300);
	rect(Kernel.BackBuffer,360,cury+2,510,cury+15,color);
	rectfill(Kernel.BackBuffer,360,cury+2,360+len,cury+15,color);
	cury+=20;

	// Bar4
	alfont_textout_right_aa_ex(Kernel.BackBuffer, Data.Font[1], "S. Recharge:", 350, cury-1, color, -1);
	len = 0;
	if (curship) len = (100-curship->ShieldRechargeRate)*150/70;
	rect(Kernel.BackBuffer,360,cury+2,510,cury+15,color);
	rectfill(Kernel.BackBuffer,360,cury+2,360+len,cury+15,color);
	cury+=20;

	// Bar5
	alfont_textout_right_aa_ex(Kernel.BackBuffer, Data.Font[1], "Speed:", 350, cury-1, color, -1);
	len = 0;
	if (curship) len = int((curship->Acceleration-0.2)*750);
	rect(Kernel.BackBuffer,360,cury+2,510,cury+15,color);
	rectfill(Kernel.BackBuffer,360,cury+2,360+len,cury+15,color);
	cury+=20;

	// Dirty
	Kernel.SetDirty(130,starty,510,starty+100);

	// Draw as base
	BaseFrame::Render();
}
