//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#ifndef PLAYER_H
#define PLAYER_H

// Dependencies
#include "sprite.h"
#include "playership.h"


// Class definition
class PlayerClass: public Sprite {
private:
	int ShotPhase;
	bool Shooting;
	int ShotHue;
	int ShotY;
	float ShotAmplitude;
	float ShotShift;
	int TakeDamage;
	int ShieldRecharge;
	int DieStep;

	BITMAP *CurrentShot;

public:
	PlayerShip *Ship;
	int TakingDamage;
	bool HasControl;
	int Appearing;
	bool Alive;
	int Life;

	PlayerClass();

	void Enable();
	void Damage(int damage);
	void Draw();
	void Update();
};


#endif
