//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

// INCLUDES
#include <allegro.h>
#include <time.h>
#define ALFONT_DLL
#include <alfont.h>
#include <algif.h>
#include "data.h"
#include "baseframe.h"
#include "playframe.h"
#include "selectframe.h"
#include "kernel.h"
#include "input.h"
#include "audio.h"
#include "highscores.h"


// DEFINE GLOBALS
DataClass Data;
KernelClass Kernel;
InputClass Input;
AudioClass Audio;
HighScoreTable HighScores;


// INIT GAME FUNCTION
void InitGame() {
	Data.Log("Entering InitGame()");
	// Seed random
	srand((unsigned)time(NULL));

	// Install devices
	Data.Log("Installing devices");
	allegro_init();
	install_timer();
	install_mouse();
	install_keyboard();
	alfont_init();
	algif_init();

	// Config file
	Data.Log("Loading config file");
	char path[512];
	Data.MakePath(path,"lots.cfg");
	set_config_file(path);
	Data.GameKeys[0] = get_config_int("controls","up",KEY_Q);
	Data.GameKeys[1] = get_config_int("controls","down",KEY_D);
	Data.GameKeys[2] = get_config_int("controls","shoot",KEY_SPACE);
	Data.GameKeys[3] = get_config_int("controls","colorleft",KEY_LEFT);
	Data.GameKeys[4] = get_config_int("controls","colorright",KEY_RIGHT);
	Data.GameKeys[5] = get_config_int("controls","altup",KEY_UP);
	Data.GameKeys[6] = get_config_int("controls","altdown",KEY_DOWN);
	Data.GameKeys[7] = get_config_int("controls","pause",KEY_P);
	Data.ColorDepth = get_config_int("video","colordepth",32);
	Data.FullScreen = get_config_int("video","fullscreen",0);

	// Set graphics mode
	Data.Log("Setting video mode");
	set_color_depth(Data.ColorDepth);
	int winW = 640;
	int winH = 480;
	int mode;
	if (Data.FullScreen == 1) mode = GFX_AUTODETECT_FULLSCREEN;
	else mode = GFX_AUTODETECT_WINDOWED;
	if (set_gfx_mode(mode, winW, winH, 0, 0) < 0) {
		allegro_message(allegro_error);
		exit(0);
	}
	Kernel.BackBuffer = create_bitmap(screen->w,screen->h);

	// Initialize sound
	Data.Log("Initializing sound");
	reserve_voices(32,32);
	int soundok = install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	if (soundok == -1) allegro_message(allegro_error);
	set_volume(255,255);

	// Set window properties
	set_window_title("The Lord of the Stars");
	set_display_switch_mode(SWITCH_PAUSE);

	// Init data
	Data.Init();
	HighScores.New();

	// Start on introframe
	Kernel.SwitchNext = 3;
}


// MAIN FUNCTION
int main() {
	Data.Log("Entering main()");
	// Init
	InitGame();

	// Main loop
	Kernel.Loop();

	// Destroy stuff
	HighScores.~HighScoreTable();
	Kernel.~KernelClass();
	Audio.~AudioClass();
	alfont_exit();

	// Return ok
	return 0;
}
END_OF_MAIN();
