//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#ifndef ENEMY_H
#define ENEMY_H


// Dependencies
#include "sprite.h"


// Enum
enum EnemyType {
	ENEMY_ORC = 0,
	ENEMY_TROLL,
	ENEMY_MINE,
	ENEMY_ASTEROID1,
	ENEMY_ASTEROID2,
	ENEMY_URUK
};


// Base class definition
class Enemy: public Sprite {
public:
	int ShootTimer;
	int Life;
	int ScoreValue;
	int Hue;
	int DieStep;
	int BlinkStep;

	void Damage (int value,int hue);

	Enemy();
	~Enemy();
	void MakeBmp (struct BITMAP* src, int colorToReplace);
	virtual void Update();
	virtual void Draw();
};


// Orc
class EnemyOrc: public Enemy {
private:

public:
	EnemyOrc();
	void Update();
	void Draw();
};


// Uruk
class EnemyUruk: public Enemy {
private:
	int targety;

public:
	EnemyUruk();
	void Update();
	void Draw();
};


// Troll
class EnemyTroll: public Enemy {
private:
	int mode;
	int targety;

public:
	EnemyTroll();
	void Update();
	void Draw();
};


// Mine
class EnemyMine: public Enemy {
private:
	int BlowDamage;
	int BlowRadius;
	int MineType;

public:
	EnemyMine();
	EnemyMine(int type);
	void Update();
	void Draw();
};

#endif
