/////////////////
// CODE BY JUSTT
/////////////////
// Written for Lord of the Stars

#ifndef NULL
#define NULL					0
#endif

#define ID_UNDEFINED            -1
#define DIALOGSCRIPT_HEADER     "dialog_script_v01"
#define DIALOG_HEADER           "Dialog"
#define MESSAGE_START           '.'

#define NO_ERROR                0
#define INVALID_PARAMETERS      1
#define INVALID_FILE            2

class DialogEntry
{
public:
      int left, right, speaker; // Participating people, speaker
      char *msg;                // Message
      DialogEntry() { left = right = speaker = ID_UNDEFINED; msg = NULL; }
};

class Dialog
{
public:
      int id;                 // Dialog id
      int n_entry;            // Number of entries
      DialogEntry **entry;    // Pointers to entries
      
      void addEntry(DialogEntry *new_entry);
      void flushEntries();
      Dialog() { id = n_entry = 0; entry = NULL; }
      ~Dialog() { flushEntries(); }
};

int LoadDialog(const char *filename, Dialog **&dlg_list, int &n_dialog);
