//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#include <fblend.h>
#include "baseframe.h"
#include "kernel.h"


// Constructor
BaseFrame::BaseFrame() {
	Fade = 255;
	FadeMode = 2;
}


// Update
bool BaseFrame::Update() {
	// Force quit
	if (key[KEY_F12]) {
		Kernel.Run = false;
		return false;
	}

	// Fade out
	if (FadeMode == 1) {
		Fade+=5;
		if (Fade >= 255) {
			FadeMode = 0;
			return false;
		}
	}

	// Fade in
	if (FadeMode == 2) {
		Fade-=5;
		if (Fade == 0) {
			FadeMode = 0;
		}
	}

	// OK
	return true;
}


// Switch
void BaseFrame::Switch(int to) {
	Kernel.SwitchNext = to;
	//Fade = 0;
	FadeMode = 1;
}


// Render
void BaseFrame::Render() {
	if (Fade != 0) {
		Kernel.RedrawAll = true;
		fblend_rect_trans (Kernel.BackBuffer,0,0,screen->w,screen->h,makecol(0,0,0),Fade);
		Kernel.SetDirty(0,0,screen->w,screen->h);
	}
}
