//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

// Headers
#include "audio.h"
#include "kernel.h"
#include "data.h"

// Constructor
AudioClass::AudioClass() {
	// Initialize variables
	CurrentMidi = NULL;
	MidiFade = 1;
	MidiFading = 0;
	MidiVolume = 0.5;
	SoundVolume = 1;
	MidiNumber = 0;
}


// Destructor
AudioClass::~AudioClass() {
	// Destroy MIDI
	if (CurrentMidi) destroy_midi(CurrentMidi);
	CurrentMidi = NULL;
}


// Update
void AudioClass::Update () {
	// Play midi if nothing is playing
	if (CurrentMidi == NULL || midi_pos == -1) {
		if (MidiFading != 1) PlayMidi();
	}

	// Fade midi out
	if (MidiFading == 1) {
		MidiFade -= 0.02;
		if (MidiFade < 0.005) {
			MidiFade = 0;
			stop_midi();
			PlayMidi();
		}
	}

	// Fade midi in
	if (MidiFading == 2) {
		MidiFade += 0.005;
		if (MidiFade > 0.99) {
			MidiFade = 1;
			MidiFading = 0;
		}
	}

	// Set volume
	set_volume(int(SoundVolume*255.0),int(MidiVolume*MidiFade*255.0));
}


// Plays a MIDI
void AudioClass::PlayMidi() {
	if (CurrentMidi) destroy_midi(CurrentMidi);
	char path[512];
	switch (MidiNumber) {
		case -1: CurrentMidi = NULL; return;
		case 0: Data.MakePath(path,"midi/intro.mid"); break;
		case 1: Data.MakePath(path,"midi/fotrintro.mid"); break;
		case 2: Data.MakePath(path,"midi/shire.mid"); break;
		case 3: Data.MakePath(path,"midi/fellowship.mid"); break;
		case 4: Data.MakePath(path,"midi/anduril.mid"); break;
		default: return;
	}
	CurrentMidi = load_midi(path);
	if (CurrentMidi) play_looped_midi(CurrentMidi,0,-1);
	FadeInMidi();
}


// Fade out MIDI
void AudioClass::FadeOutMidi() {
	if (MidiFading == 0) MidiFade = 1;
	MidiFading = 1;
}


// Fade in MIDI
void AudioClass::FadeInMidi() {
	if (MidiFading == 0) MidiFade = 0;
	MidiFading = 2;
}


// Set MIDI
void AudioClass::SetMidi(int i) {
	if (MidiNumber != i) {
		MidiNumber = i;
		FadeOutMidi();
	}
}
