//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

// Headers
#include <allegro.h>
#include <math.h>
#include "sprite.h"
#include "kernel.h"
#include "playframe.h"
#include "particle.h"


// Constructor
Sprite::Sprite() {
	x = 0;
	y = 0;
	vx = 0;
	vy = 0;
	ax = 0;
	ay = 0;
	px = 0;
	py = 0;
	shootx = 0;
	shooty = 0;
	bmp = NULL;
}


// Update
void Sprite::Update() {
	vx += ax;
	vy += ay;
	x += vx;
	y += vy;
}


// Render
void Sprite::Draw() {
	if (bmp) {
		int dx = int(x)-px;
		int dy = int(y)-py;
		draw_sprite(Kernel.BackBuffer,bmp,dx,dy);
		Kernel.SetDirty(dx,dy,bmp->w,bmp->h);
	}
}


// Die
void Sprite::Destroy() {
	parent->Sprites.remove(this);
	delete this;
}


// Collision check
bool Sprite::Collides(Sprite *target) {
	if (pow(x-target->x,2)+pow(y-target->y,2) <= pow(radius+target->radius,2)) return true;
	else return false;
}


// Collision check with point
bool Sprite::Collides(int tx,int ty,int tr) {
	if (pow(x-tx,2)+pow(y-ty,2) <= pow(radius+tr,2)) return true;
	else return false;
}


// Creates a Particle
Particle *Sprite::CreateParticle () {
	Particle *spawn = new Particle;
	parent->AddSprite(spawn);
	spawn->x = x+shootx;
	spawn->y = y+shooty;
	return spawn;
}
