//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

// Headers
#include <math.h>
#include <allegro.h>
#include <fblend.h>
#include "player.h"
#include "kernel.h"
#include "playframe.h"
#include "input.h"
#include "data.h"
#include "particle.h"


// Constructor
PlayerClass::PlayerClass() {
	// Initialize vars
	Ship = Data.Ships[Data.pilot-1];
	y = 240;
	px = 24;
	py = 12;
	radius = 10;
	Type = SPRITE_TYPE_PLAYER;
	Enable();

	// Load bitmaps
	char temp[512];
	sprintf(temp,"Current pilot: %i",Data.pilot);
	Data.Log(temp);
	bmp = Data.Ships[Data.pilot-1]->bmp;
	CurrentShot = NULL;
}


// Update
void PlayerClass::Update() {
	// Alive?
	if (!Alive) return;

	// Appearing sequence
	if (Appearing > 0) {
		Appearing--;
		x++;
		if (Appearing == 0) {
			HasControl = true;
			TakingDamage = 120;
		}
	}

	// Controls
	ax = 0;
	ay = 0;
	float acl = Ship->Acceleration;
	float speed = acl * 30;
	if (HasControl) {
		if (key[Data.GameKeys[0]] || key[Data.GameKeys[5]]) ay = -acl;
		if (key[Data.GameKeys[1]] || key[Data.GameKeys[6]]) ay = acl;
	}
	if (ay == 0) vy *= 0.95;

	// Limit speed
	if (ay > 2) ay = 2;
	if (ay < -2) ay = -2;
	if (vy > speed) vy = speed;
	if (vy < -speed) vy = -speed;

	// Update as sprite
	Sprite::Update();

	// Limit position
	if (y < 60) {
		y = 60;
		vy = 0;
	}
	if (y > 440) {
		y = 440;
		vy = 0;
	}

	// Modify life
	if (TakingDamage != 0) {
		TakingDamage--;
	}
	if (TakeDamage > 0) {
		if (TakeDamage > 15) {
			TakeDamage -= 2;
			Life -= 2;
		}
		TakeDamage--;
		Life--;
	}
	if (TakeDamage < 0) {
		if (TakeDamage < -15) {
			TakeDamage += 2;
			Life += 2;
		}
		TakeDamage++;
		Life++;
	}
	if (Life < 0) Life = 0;

	// Die
	if (Life <= 0 && DieStep == 0) {
		DieStep = 1;
		Particle *debris;
		for (int i=0;i<20;i++) {
			debris = CreateParticle();
			debris->Friendly = true;
			debris->DrawMethod = 0;
			debris->bmp = Data.DebrisBmp;
			debris->vx = (rand()%9-4)*2-1;
			debris->vy = (rand()%9-4)*2+1;
			debris->px = 3;
			debris->py = 3;
		}
		play_sample(Data.Sample[3],255,MIN(MAX(0,int(x)*255/screen->w),255),1000,0);
	}

	// Dying
	if (DieStep > 0) {
		Particle *explosion;
		for (int i=0;i<5;i++) {
			explosion = CreateParticle();
			explosion->Friendly = true;
			explosion->DrawMethod = 1;
			explosion->ttl = 10;
			explosion->bmp = Data.ExplosionBmp;
			explosion->vx = rand()%9-4;
			explosion->vy = rand()%9-4;
			explosion->px = 16;
			explosion->py = 16;
			explosion->x += rand()%13-6;
			explosion->y += rand()%13-6;
		}

		DieStep++;
		if (DieStep == 10) {
			DieStep = 0;
			Alive = false;
			HasControl = false;
			return;
		}
	}

	// Recharge Shield
	ShieldRecharge++;
	if (ShieldRecharge >= Ship->ShieldRechargeRate) {
		ShieldRecharge = 0;
		Life++;
		if (Life > Ship->MaxLife) Life = Ship->MaxLife;
	}

	// Shoot
	if (!Shooting && HasControl && !parent->Dialogue) {
		if (Input.MouseDown[0] || Input.KeyDown[Data.GameKeys[2]]) {
			parent->JustShot = true;
			Shooting = true;
			ShotPhase = 0;
			ShotY = int(y);
			ShotShift = float(rand() % 629) / 100.0;
			ShotHue = int(parent->SliderPos * 360 / screen->w);

			// Create bitmap for this shot
			if (CurrentShot) destroy_bitmap(CurrentShot);
			CurrentShot = create_bitmap(32,32);
			for (int x=32;--x>=0;) {
				for (int y=32;--y>=0;) {
					float v = float(getr(getpixel(Data.PlayerShotBmp,x,y)))/255;
					putpixel(CurrentShot,x,y,parent->GetCurrentSliderColor(1-v*0.5,v));
				}
			}
		}
	}

	// Shooting
	else {
		ShotPhase++;
		if (ShotPhase == 30) {
			ShotPhase = 0;
			Shooting = false;
		}
	}
}


// Render
void PlayerClass::Draw() {
	// Alive?
	if (!Alive) return;

	// Shots
	if (Shooting) {
		for (int i=ShotPhase*4;i<40+ShotPhase*4;i++) {
			int dx = int(x)+16+i*5+rand()%5-2+ShotPhase*6;
			int dy = ShotY-16+rand()%5-2+int(sin(float(i)/4.0+ShotShift)*(float(i)+5)/160.0*ShotAmplitude);
			fblend_add(CurrentShot,Kernel.BackBuffer,dx,dy,255);
			Kernel.SetDirty(dx,dy,32,32);
			parent->DamageArea(ShotHue,Ship->Damage,dx+16,dy+16,16);
		}
		int midx = ShotPhase*26+116+int(x);
		adjust_sample(Data.Sample[1],255,MAX(0,MIN(midx*255/screen->w,255)),1000,0);
	}

	// Draw as sprite
	if (TakingDamage && (TakingDamage/4) % 2 == 0 || DieStep != 0) {
		int dx = int(x)-px;
		int dy = int(y)-py;
		set_color_blender(255,255,255,255);
		draw_lit_sprite(Kernel.BackBuffer,bmp,dx,dy,255);
		Kernel.SetDirty(dx,dy,bmp->w,bmp->h);
	}
	else Sprite::Draw();
}


// Damages
void PlayerClass::Damage(int damage) {
	if (TakingDamage != 0 || Life <= 0 || HasControl == false) return;

	play_sample(Data.Sample[2],255,MIN(255,MAX(int(x)*255/screen->w,0)),1000,0);
	TakeDamage += int(float(damage) * Ship->DamageResistance);
	TakingDamage = 60;
	vy += (((rand()%2)*2)-1)*3;
}


// Enables player
void PlayerClass::Enable() {
	vy = 0;
	ay = 0;
	DieStep = 0;
	ShotPhase = 0;
	ShotAmplitude = 50;
	ShotShift = 0;
	TakeDamage = 0;
	TakingDamage = false;
	ShieldRecharge = 0;
	Shooting = false;
	Alive = true;
	HasControl = false;
	Appearing = 90;
	TakeDamage = -Ship->MaxLife;
	y = screen->h/2;
	x = -40;
	Life = 0;
}
