//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#include <allegro.h>
#include <fblend.h>
#include "particle.h"
#include "playframe.h"
#include "player.h"
#include "kernel.h"


// Constructor
Particle::Particle() {
	DrawMethod = 0;
	Friendly = false;
	DiesOnHit = true;
	Damage = 0;
	time = 0;
	ttl = 0;
}


// Update
void Particle::Update() {
	// Update as sprite
	Sprite::Update();

	// Checks for collision with player
	if (!Friendly) {
		if (parent->Player->Alive && Collides(parent->Player)) {
			parent->Player->Damage(Damage);
			if (DiesOnHit) {
				Destroy();
				return;
			}
		}
	}

	// Time
	time++;
	if (ttl != 0 && time >= ttl) {
		Destroy();
		return;
	}

	// Checks if is outside screen
	int w = 1;
	int h = 1;
	if (bmp) {
		w = bmp->w;
		h = bmp->h;
	}
	if (x < -w || x >= screen->w + w || y < -h || y >= screen->h + h) {
		Destroy();
		return;
	}
}


// Draw
void Particle::Draw() {
	int dx,dy;
	switch (DrawMethod) {
		case 0: 
			Sprite::Draw();
			break;
		case 1:
			dx = int(x)-px;
			dy = int(y)-py;
			fblend_add(bmp,Kernel.BackBuffer,dx,dy,255);
			Kernel.SetDirty(dx,dy,bmp->w,bmp->h);
			break;
		case 2:
			putpixel(Kernel.BackBuffer,(int)x,(int)y,Color);
			Kernel.SetDirty((int)x,(int)y,1,1);
			break;
	}
}
