//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#ifndef KERNEL_H
#define KERNEL_H


// Class definition
class KernelClass {	
public:
	int SwitchNext;
	bool Run;
	struct BITMAP *BackBuffer;
	class BaseFrame* CurrentFrame;

	bool SetGraphicsMode;
	bool RedrawAll;
	char DirtyRects[80][60];

	void SetDirty(int x,int y,int w,int h);
	void BlitScreen();
	void Loop();
	bool UpdateCurrentFrame();
	void RenderCurrentFrame();

	void NextFrame();
	KernelClass ();
	~KernelClass ();
};


// Extern prototype
extern KernelClass Kernel;


#endif
