//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

// Headers
#include "input.h"

// Initialize
InputClass::InputClass() {
	for (int i=0;i<KEY_MAX;i++) {
		KeyDown[i] = false;
		KeyUp[i] = false;
		PrevKey[i] = false;
	}
	for (int i=0;i<MOUSE_MAX;i++) {
		MouseDown[i] = false;
		MouseUp[i] = false;
		PrevMouse[i] = false;
	}
}


// Update keyboard and mouse state
void InputClass::Update() {
	// Fill KeyUp and KeyDown arrays
	for (int i=0;i<KEY_MAX;i++) {
		if (key[i] && !(PrevKey[i])) KeyDown[i] = true;
		else KeyDown[i] = false;

		if (!(key[i]) && PrevKey[i]) KeyUp[i] = true;
		else KeyUp[i] = true;
	}

	// Copy current keys to previous buffer
	for (int i=0;i<KEY_MAX;i++) {
		PrevKey[i] = false;
		if (key[i]) PrevKey[i] = true;
	}

	// Fill MouseUp and MouseDown arrays
	for (int i=0;i<MOUSE_MAX;i++) {
		if (mouse(i) && !(PrevMouse[i])) MouseDown[i] = true;
		else MouseDown[i] = false;

		if (!(mouse(i)) && PrevMouse[i]) MouseUp[i] = true;
		else MouseUp[i] = true;
	}

	// Copy current buttons to previous buffer
	for (int i=0;i<MOUSE_MAX;i++) {
		PrevMouse[i] = false;
		if (mouse(i)) PrevMouse[i] = true;
	}
}


// Is mouse button pressed?
bool InputClass::mouse(int button) {
	if (mouse_b & (1 << button)) return true;
	else return false;
}
