//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#ifndef DATA_H
#define DATA_H


// Prototypes
struct BITMAP;


// DataClass class definition
class DataClass {
public:
	bool Unlocked[5];
	int UnlockCode[5];
	int NewUnlock;
	int pilot;
	bool Logging;

	int ColorDepth;
	int FullScreen;

	int GameKeys[8];
	BITMAP *PlayerShotBmp;
	BITMAP *EnemyBmp[8];
	BITMAP *EnemyShotBmp[8];
	BITMAP *DialogueBmp;
	BITMAP *ExplosionBmp;
	BITMAP *DebrisBmp;
	BITMAP *LogoBmp;

	SAMPLE *Sample[16];

	struct ALFONT_FONT *Font[8];
	class People *Person[16];
	class PlayerShip *Ships[9];
	class Dialog **Dialogue;
	int n_diags;

	DataClass();
	int HSVtoRGB(float H,float S,float V);
	void Unlock(int i);
	void UnlockNext();
	void Log(const char* string);
	void Init();
	void MakePath(char *path,const char *src);
	int BreakText(const char *text,int x,int y,int len,ALFONT_FONT *tfont,int color);
};


// Extern prototype
extern DataClass Data;


#endif
