//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#include <allegro.h>
#include <stdio.h>
#include <string.h>
#include "highscores.h"
#include "data.h"


// Constructor
HighScoreTable::HighScoreTable () {
	alive = true;
}


// Destructor
HighScoreTable::~HighScoreTable () {
	if (alive) {
		char path[512];
		Data.MakePath(path,"highscore.dat");
		Save(path);
		alive = false;
	}
}


// Cleans it
void HighScoreTable::New() {
	for (int i=0;i<10;i++) {
		score[i] = 0;
		for (int j=0;j<32;j++) name[i][j] = 0;
		strcpy(name[i],"Empty");
	}
	char path[512];
	Data.MakePath(path,"highscore.dat");
	if (exists(path)) Load(path);
}


// Loads from disk
void HighScoreTable::Load(const char *path) {
	FILE *fp;
	fp = fopen(path,"r");
	fread(score,sizeof(long int),10,fp);
	fread(name,sizeof(char),320,fp);
	fclose(fp);
}


// Saves to disk
void HighScoreTable::Save(const char *path) {
	FILE *fp;
	fp = fopen(path,"w");
	fwrite(score,sizeof(long int),10,fp);
	fwrite(name,sizeof(char),320,fp);
	fclose(fp);
}


// Is high?
int HighScoreTable::ScorePos(int _score) {
	for (int i=0;i<10;i++) {
		if (_score > score[i]) return i;
	}
	return -1;
}


// Inserts
void HighScoreTable::Insert(int _score,const char *_name) {
	int pos = ScorePos(_score);
	if (pos == -1) return;
	for (int i=10;--i>=0;) {
		if (i > pos) {
			strcpy(name[i],name[i-1]);
			score[i] = score[i-1];
		}
		else if (i == pos) {
			strcpy(name[i],_name);
			score[i] = _score;
		}
		else break;
	}
}
