
#ifndef SYNTH_H
#define SYNTH_H

extern int master_sample_rate;
extern int timestretch;
extern int globalgain;

const int sb_shift = 4;
const int sb_size = 1 << sb_shift;
const int sb_times = 128;

struct sbuffer
{ int buf[ sb_size ]; };

extern sbuffer zero_sbuffer;
extern sbuffer unit_sbuffer;

extern int rate_values[16];
extern int levela_values[16];
extern int levelf_values[16];
extern int qfactor_values[16];

extern int semi[16];
extern int notes[7];

int val( istream &is );

void timer();

sbuffer operator +( const sbuffer &, const sbuffer & );
sbuffer operator -( const sbuffer &, const sbuffer & );
sbuffer operator *( const sbuffer &, const sbuffer & );
sbuffer operator *( const int, const sbuffer & );

struct csinus_table
{
   int y[65536];
   csinus_table();
};

extern csinus_table sinus;

struct cBLIT
{
   int freq, lastfreq, phase, n, a;
   cBLIT() { freq = lastfreq = phase = 0; n = 0; a = 0; }
   sbuffer pace();
};

struct cwave
{
   int freq, lastfreq, width, type, s, s2, n, m;
   cBLIT BLIT[2];
   cBLIT sync;
   cwave() { freq = lastfreq = width = type = s = s2 = 0; n = 0; m = 1; };
   sbuffer pace();
};

struct cenvelope
{
   int active, ay, ar, dy, dr, sl, y;

   cenvelope() { ay = dy = ar = dr = sl = y = dy = 0; active = 0; }
   void sets( int sl ) { this->sl = sl << 6; }
   void trig() { dy = ( ay = ( ay + dy >> 6 ) / 2 ) << 6; }
   void kick( int k ) { ay -= k; dy += k << 6; active = true; }

   int pace()
   { return ( ay -= ar * ay >> 12 ) + ( ( dy += dr * ( sl - dy ) >> 12 ) >> 6 ); }

   sbuffer pace( const sbuffer  &in );
};

struct cfilter
{
   int x, s, v, f, q;
   cfilter() { x = s = v = f = q = 0; }
   sbuffer pace( const sbuffer  &in );
};

struct cvoice
{
   virtual void command( istream  & ) = 0;
   virtual sbuffer pace() = 0;
};

struct cvoice_mono : cvoice
{
   cwave wave;
   cfilter filter;
   cenvelope aenv, fenv;
   int freq, oct, aar, adr, asl, arr, far, fdr, fsl, frr, ff, fq,
       vc, vd, vf, vp, vl, s, s2, pw, pws, pwm, pwf, pwc, pwu, pwd, trans;

   cvoice_mono();
   void trig( int );
   void rel();
   void command( istream  & );
   sbuffer pace();
};

struct cchord : cvoice
{
   int freq, oct, boost;
   cvoice_mono voice[3];
   cchord() { freq = oct = 0; boost = 0; }
   void command( istream & );

   sbuffer pace();
};

struct cdrums : cvoice
{
   cenvelope base_aenv;
   cenvelope base_fenv;
   cfilter base_filter;
   cenvelope snare_aenv;
   cfilter snare_filter;
   cenvelope hhat_aenv;
   cfilter hhat_filter;

   int base_sens, base_kick, base_noise, snare_kick, snare_noise,
       hhat_open_dr, hhat_close_dr, hhat_kick;

   cdrums();
   void command( istream & );
   sbuffer pace();
};

struct csequencer
{
   int play, count, beat, level, block_p[26], return_p[5], return_count;
   int beatmodulo, countmodulo;
   istream &is;
   cvoice *voice;
   sbuffer out;
   int ring, mute;

   csequencer( istream &is ) : is( is ), voice( new cvoice_mono )
      { count = countmodulo = return_count = 0; beatmodulo = beat = 1; play = 1; 
        level = 16384; out = zero_sbuffer; mute = ring = 0; }

   sbuffer pace();
};

struct cdelay
{
   int *buffer1, *buffer2, *buffer3, *buffer4, *buffer5, *buffer6;
   int write1, write2, write3, write4, write5, write6;
   int n1, n2, n3, n4, n5, n6;
   int i1, i2, i3, i4, i5, i6;
   int c1, c2, c3, c4, c5, c6;
   int low1, low2, low3, low4, low5, low6;
   int pole;

   cdelay( int, int, int, int, int, int );
   ~cdelay();
   sbuffer pace( const sbuffer & );
   void set_coeff( double, double );
};


#endif

