#ifndef interface_grafico_h
 #define interface_grafico_h
  //Lo normal es no poner Codigo en los .H, pero esto no es NORMAL 8-D))

  #ifdef ALLEGRO_DOS
   char *listbox_datos_sonido(int i, int* l){
    static char *strings[]={"AUTO","SB 1.0","SB 1.5","SB 2.0","SB PRO","SB 16","ESS","ESC","WSS"};
    if (i<0){ *l=9;return NULL; }
    else return strings[i];
   }
  #endif

  #ifdef ALLEGRO_WINDOWS
   char *listbox_datos_sonido(int i, int* l){
    static char *strings[]={"AUTO","DX 0","DX 1","ALLEG 0","ALLEG 1","WAVLOW","WAVHIGH"};
    if (i<0){ *l=7;return NULL; }
    else return strings[i];
   }
  #endif

  #ifdef ALLEGRO_LINUX
   char *listbox_datos_sonido(int i, int* l){
    static char *strings[]={"AUTO","OSS","ESD","ARTS","ALSA"};
    if (i<0){ *l=5;return NULL; }
    else return strings[i];
   }
  #endif

  #ifdef ALLEGRO_BEOS
   char *listbox_datos_sonido(int i, int* l){
    static char *strings[]={"AUTO","BEOS"};
    if (i<0){ *l=2;return NULL; }
    else return strings[i];
   }
  #endif

  char *listbox_datos_resolucion(int i, int* l){
   static char *strings[]={"640x480","640x400","320x240","320x200"};
   if (i<0){ *l=4;return NULL; }
   else return strings[i];
  }

  #ifdef ALLEGRO_DOS
   char *listbox_datos_driver(int i, int* l){
    static char *strings[]={"AUTO","VESA 3", "VESA 2 L","VESA 2 B","VBEAF", "VESA 1","XTND","MODX","VGA"};
    if (i<0){ *l=9;return NULL; }
    else return strings[i];
   }
  #endif

  #ifdef ALLEGRO_WINDOWS
   char *listbox_datos_driver(int i, int* l){
    static char *strings[]={"AUTO","DX", "DXACCEL","DXSOFT","DXSAFE","DXWIN","OVERLAY","GDI"};
    if (i<0){ *l=8;return NULL; }
    else return strings[i];
   }
  #endif

  #ifdef ALLEGRO_LINUX
   char *listbox_datos_driver(int i, int* l){
    static char *strings[]={"AUTO","XWINDOWS","XDGA","XDGA2","FBCON","VBEAF","SVGALIB","VGA","MODX"};
    if (i<0){ *l=9;return NULL; }
    else return strings[i];
   }
  #endif

  #ifdef ALLEGRO_BEOS
   char *listbox_datos_driver(int i, int* l){
    static char *strings[]={"AUTO","BDIRECT","BWINDOW","OVERLAY","ACCEL"};
    if (i<0){ *l=5;return NULL; }
    else return strings[i];
   }
  #endif

  char *listbox_datos_efecto(int i, int* l){
   static char *strings[]={"NULO","V-METER","V-METER2","V-METER3","V-METER4","TRANSPA1","TRANSPA2","DEGRADA1","DEGRADA2"};
   if (i<0){ *l=9;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_puerto(int i, int* l){
   static char *strings[]={"VOX","COM1","COM2","COM3","COM4"};
   if (i<0){ *l=5;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_minisegundos(int i, int* l){
   static char *strings[]={"0''","1''","2''","3''","4''"};
   if (i<0){ *l=5;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_tx(int i, int* l){
   static char *strings[]={"10''","20''","30''","40''","50''","60''","70''","80''","90''"};
   if (i<0){ *l=9;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_porcentajes(int i, int* l){
   static char *strings[]={"10%","20%","30%","40%","50%","60%","70%","80%","90%"};
   if (i<0){ *l=9;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_segundos(int i, int* l){
   static char *strings[]={"0''","1''","2''","3''","4''","5''","6''","7''","8''","9''","10''"};
   if (i<0){ *l=10;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_khz(int i, int* l){
   static char *strings[]={"4000","5000","6000","7000","8000","11025","16000","22050","32000","44100"};
   if (i<0){ *l=10;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_grabar(int i, int* l){
   static char *strings[]={"LINE","MIC","CD"};
   if (i<0){ *l=3;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_milisegundos(int i, int* l){
   static char *strings[]={"0''","0.1''","0.2''","0.3''","0.4''","0.5''","0.6''","0.7''","0.8''","0.9''","1''","1.1''","1.2''","1.3''","1.4''","1.5''","1.6''","1.7''","1.8''","1.9''","2''"};
   if (i<0){ *l=21;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_baliza(int i, int* l){
   static char *strings[]={"NULA","VOZ"};
   if (i<0){ *l=2;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_tiempo_baliza(int i, int* l){
   static char *strings[]={"1 '","2 '","5 '","10 '","20 '","30 '","50 '","60 '"};
   if (i<0){ *l=8;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_bits(int i, int* l){
   static char *strings[]={"8","16"};
   if (i<0){ *l=2;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_refresco(int i, int* l){
   static char *strings[]={"0","60","70","72","75"};
   if (i<0){ *l=5;return NULL; }
   else return strings[i];
  }

  char *listbox_datos_volumen(int i, int* l){
   static char *strings[]={"10","9","8","7","6","5","4","3","2","1"};
   if (i<0){ *l=10;return NULL; }
   else return strings[i];
  }


  enum TEfecto {nulo,vmeter,vmeter2,vmeter3,vmeter4,transpa1,transpa2,degrada1,degrada2};
  enum TTipoVideo {video_tx, video_rx, video_sanciontx, video_tx2rx,video_repetidor};

  DIALOG dialogoOpcionesVideo[] =
  {
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)       (d2)  (dp)               (dp2) (dp3) */
   { d_shadow_box_proc, 0,     0,  141,  138,   0,    223,    0,    0,       0,         0,    NULL,              NULL, NULL  },
   { d_button_proc,     40,   130, 90,   15,    12,    222,    KEY_A,    D_EXIT,       0,         0,    "&Aceptar",       NULL, NULL },
   { d_check_proc,      2,     2,   75,   10,   12,    223,    0,    D_SELECTED,      0,         0,    "VENTANA",       NULL, NULL },
   { d_check_proc,      84,   2,   75,   10,   0,    223,    0,    0,      0,         0,    "SETUP",       NULL, NULL },
   { d_text_proc,       2,    15,  60,   10,   0,    223,    0,    0,       9,         0,    "VIDEO",   NULL, NULL  },
   { d_list_proc,       48,   13,  90,   12,   128,    223,    0,    0,       0,         0,    listbox_datos_driver,  0, NULL },
   { d_text_proc,       2,    28,  70,   10,   0,    223,    0,    0,       9,         0,    "PIXELS",   NULL, NULL  },
   { d_list_proc,       53,   26,   85,   12,   128,    223,    0,    0,       0,         0,    listbox_datos_resolucion,  0, NULL },
   { d_text_proc,       2,    41,   90,   10,   0,    223,    0,    0,       9,         0,    "SONIDO",   NULL, NULL  },
   { d_list_proc,       53,   39,   85,   12,   128,    223,    0,    0,       0,         0,    listbox_datos_sonido,  0, NULL },
   { d_text_proc,       2,    54,   75,   10,   0,    223,    0,    0,      9,         0,    "LINEA",       NULL, NULL },
   { d_list_proc,       50,   52,   88,   12,   128,    223,    0,    0,       0,         0,    listbox_datos_grabar,  0, NULL },
   { d_text_proc,       2,    67,   75,   10,   0,    223,    0,    0,      9,         0,    "FREC Hz",       NULL, NULL },
   { d_list_proc,       65,   65,   73,   12,   128,    223,    0,    0,       5,         0,    listbox_datos_khz,  0, NULL },
   { d_text_proc,       2,    80,   90,  10,   0,    223,    0,    0,       9,         0,    "PUERTO TX",   NULL, NULL  },
   { d_list_proc,       79,   78,   59,  12,   128,    223,    0,    0,       0,         0,    listbox_datos_puerto,  0, NULL },
   { d_text_proc,       2,    93,   90,  10,   0,    223,    0,    0,       9,         0,    "BIT",   NULL, NULL  },
   { d_list_proc,       27,   91,   44,  12,   128,    223,    0,    0,       0,         0,    listbox_datos_bits,  0, NULL },
   { d_text_proc,       77,   93,   90,  10,   0,    223,    0,    0,       9,         0,    "HZ",   NULL, NULL  },
   { d_list_proc,       94,   91,   44,  12,   128,    223,    0,    0,       0,         0,    listbox_datos_refresco,  0, NULL },
   { d_check_proc,      2,    106,   75,  10,   0,    223,    0,    0,      0,         0,    "DUPLEX",       NULL, NULL },
   { d_text_proc,       67,   107,   90,  10,   0,    223,    0,    0,       9,         0,    "VOL",   NULL, NULL  },
   { d_list_proc,       93,   104,   45,  12,   128,    223,    0,    0,       0,         0,    listbox_datos_volumen,  0, NULL },   
   { d_check_proc,      2,    117,   52,  10,   0,    223,    0,    0,      0,         0,    "TEST",       NULL, NULL },
   { d_check_proc,      68,   117,   75,  10,   0,    223,    0,    D_SELECTED,      0,         0,    "PORTADA",       NULL, NULL },
   { NULL,              0,    0,    0,    0,     0,    0,    0,    0,       0,         0,    NULL,              NULL, NULL  }   
  };
  
  DIALOG dialogo[] =
  {
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)       (d2)  (dp)               (dp2) (dp3) */
//   { d_clear_proc,      0,    0,    0,    0,    255,  255,    0,    0,       0,         0,    NULL,              NULL, NULL  },
   { d_shadow_box_proc, 1,   1,   280,  80,   0,    255,    0,    0,       0,         0,    NULL,              NULL, NULL  },
   { d_button_proc,     195, 67,  90,   20,   0,    255,    KEY_A,    D_EXIT,       0,         0,    "&Aceptar",       NULL, NULL },
   { d_text_proc,       3,    5,   60,   10,   0,    255,    0,    0,       0,         0,    "EFECTO",   NULL, NULL  },
   { d_list_proc,       51,   3,   90,   12,   0,    255,    0,    0,       0,         0,    listbox_datos_efecto,  0, NULL },
   { d_text_proc,       171,  5,   100,  10,   0,    255,    0,    0,       9,         0,    "UMBRAL RX",   NULL, NULL  },
   { d_list_proc,       221,  3,   55,   12,   0,    255,    0,    0,       0,         0,    listbox_datos_porcentajes,  0, NULL },
   { d_text_proc,       3,   18,   100,  10,   0,    255,    0,    0,       9,         0,    "TX TOPE",  NULL, NULL  },
   { d_list_proc,       61,  16,   60,   12,   0,    255,    0,    0,       2,         0,    listbox_datos_tx,  0, NULL },
   { d_text_proc,       131, 18,  150,   10,   0,    255,    0,    0,       9,         0,    "SANCION TX",   NULL, NULL  },
   { d_list_proc,       216, 16,   60,   12,   0,    255,    0,    0,       6,         0,    listbox_datos_segundos,  0, NULL },
   { d_text_proc,       3,   31,  150,   10,   0,    255,    0,    0,       9,         0,    "UMBRAL TX OFF",     NULL, NULL  },
   { d_list_proc,       111, 29,   50,   12,   0,    255,    0,    0,       2,         0,    listbox_datos_minisegundos,  0, NULL },
   { d_text_proc,       176, 31,  100,   10,   0,    255,    0,    0,       9,         0,    "TX-RX",     NULL, NULL  },
   { d_list_proc,       221, 29,   55,   12,   0,    255,    0,    0,       1,         0,    listbox_datos_minisegundos,  0, NULL },
   { d_check_proc,      3,   42,   75,   10,   0,    255,    0,    0,      0,         0,    "LOG TXT",       NULL, NULL },
   { d_check_proc,      91,  42,   75,   10,   0,    255,    0,    0,      0,         0,    "LOG RAW",       NULL, NULL },
   { d_check_proc,      190, 42,  140,   10,   0,    255,    0, D_SELECTED,  0,         0,    "REPETIDOR",       NULL, NULL },
   { d_text_proc,       3,   55,  100,   10,   0,    255,    0,    0,       9,         0,    "ESPERA PTT",     NULL, NULL  },
   { d_list_proc,       91,  53,   65,   12,   0,    255,    0,    0,       5,         0,    listbox_datos_milisegundos,  0, NULL },
   { d_text_proc,       161, 55,  70,   10,   0,    255,    0,    0,       9,         0,    "BALIZA",     NULL, NULL  },
   { d_list_proc,       211, 53,  65,   12,   0,    255,    0,    0,       0,         0,    listbox_datos_baliza,  0, NULL },
   { d_text_proc,       3,   68,  70,   10,   0,    255,    0,    0,       9,         0,    "TIEMPO BALIZA",     NULL, NULL  },
   { d_list_proc,       111, 66,  65,   12,   0,    255,    0,    0,       2,         0,    listbox_datos_tiempo_baliza,  0, NULL },
   { NULL,              0,    0,    0,    0,     0,    0,    0,    0,       0,         0,    NULL,              NULL, NULL  }
  };

  int interfaceGrafico;
  enum TEfecto parametroEfecto=nulo;

  BITMAP *videoTemporal= NULL;
  BITMAP *capturaPantalla= NULL;

  void MuestraTablero(void);
  void MostrarVideo(enum TTipoVideo tipo);
  void MostrarPlugin(enum TEfecto tipo, unsigned char *buffer, int tam, BITMAP *aux);
  void MostrarPortada();


  /****************************************************/  
  void MuestraTablero(void){
   BITMAP * aux = NULL;
   int i;
   PALETTE paletaAux;
   vsync();
   clear_bitmap(screen);
   for (i=0;i<16;i++){
    paletaAux[i+240].r=paletaAux[i+240].g=paletaAux[i+240].b=(i*4);
   }
   if (datos_graficos!=NULL){
    aux= datos_graficos[FOTO_SKIN_FONDO].dat;
    vsync();
    set_palette(black_palette);
    stretch_blit(aux,screen,0,0,aux->w,aux->h,0,0,anchoX,altoY);    
    set_palette(datos_graficos[PALETA_SKIN_FONDO].dat);
    set_palette_range(paletaAux,240,255,TRUE);
    //hline(screen,1,50,320,191);
    //hline(screen,1,150,320,191);
    if (parametroEfecto!=nulo){
     switch (anchoX){
      case 320: blit(screen,capturaPantalla,0,52,0,0,capturaPantalla->w,capturaPantalla->h); break;
      case 640: blit(screen,capturaPantalla,200,152,0,0,capturaPantalla->w,capturaPantalla->h); break;
     }
    }
    aux= NULL;
   }   
  }

  /***********************************/
  void MostrarVideo(enum TTipoVideo tipo){
   BITMAP *aux= NULL;
   if (datos_graficos!=NULL){
    switch (tipo){    
     case video_tx: aux= datos_graficos[FOTO_TX].dat; break;
     case video_rx: aux= datos_graficos[FOTO_RX].dat; break;
     case video_sanciontx: aux= datos_graficos[FOTO_SANCIONTX].dat; break;
     case video_tx2rx: aux= datos_graficos[FOTO_TX2RX].dat; break;
     case video_repetidor: aux= datos_graficos[FOTO_REPETIDOR].dat; break;
    }
    vsync();
    blit(aux,screen,0,0,10,1,aux->w,aux->h);
    aux= NULL;
   }
  }

  /***************************************/
  void MostrarPlugin(enum TEfecto tipo, unsigned char *buffer, int tam, BITMAP *aux){
  //Imagina k hace
   unsigned char auxColor[480]; //Por si acaso lo declaro mayor k el alto
   int i,x,y,inc;
   unsigned long direccion;
   if (tipo!=nulo){
    if (aux!=NULL){
     inc= tam/320; tam=320;
     //clear_bitmap(aux);
     blit(capturaPantalla,aux,0,0,0,0,capturaPantalla->w,capturaPantalla->h);
     //rectfill(aux,0,0,319,94,0);
     switch (tipo){
      case vmeter:
                   #ifdef ALLEGRO_DOS
                    for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; aux->line[y][i] = 255;}
                   #endif
                   #ifndef ALLEGRO_DOS
 //                   for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; putpixel(aux,i,y,255);}
                    bmp_select(aux);
                    for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; direccion= bmp_write_line(aux,y); bmp_write8(direccion+i,255); }
                    bmp_unwrite_line(aux);
                   #endif
                   break;
      case vmeter2:
                    #ifdef ALLEGRO_DOS
                     for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; aux->line[y][i] = (buffer[i*inc]>>4)+240;}
                    #endif
                    #ifndef ALLEGRO_DOS
  //                   for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; putpixel(aux,i,y,(buffer[i*inc]>>4)+240);}
                     bmp_select(aux);
                     for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; direccion= bmp_write_line(aux,y); bmp_write8(direccion+i,(buffer[i*inc]>>4)+240); }
                     bmp_unwrite_line(aux);
                    #endif
                    break;
      case vmeter3: for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; vline(aux,i,94,y,255);}
                    break;
      case vmeter4: for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; vline(aux,i,94,y,(buffer[i*inc]>>4)+240);}
                    break;
      case transpa1:
                     #ifdef ALLEGRO_DOS
                      for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; for (j=0;j<y;j++) aux->line[j][i]= (((aux->line[j][i])>>4)+240); }
                     #endif
                     #ifndef ALLEGRO_DOS
                      for (i=0;i<tam;i++){
                       y=(buffer[i*inc]>>2)+14;
                       for (j=0;j<y;j++)
                        auxColor[j]= (_getpixel(aux,i,j)>>4)+240;
                       for (j=0;j<y;j++)
                        _putpixel(aux,i,j,auxColor[j]);
                      }
                     #endif
                     break;
      case transpa2:
                     #ifdef ALLEGRO_DOS
                      for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; for (j=y;j<94;j++) aux->line[j][i]= (((aux->line[j][i])>>4)+240); }
                     #endif
                     #ifndef ALLEGRO_DOS
                      for (i=0;i<tam;i++){
                       y=(buffer[i*inc]>>2)+14;
                       for (j=y;j<94;j++)
                        auxColor[j]= (_getpixel(aux,i,j)>>4)+240;
                       for (j=y;j<94;j++)
                        _putpixel(aux,i,j,auxColor[j]);
                      }
                     #endif
                     break;
      case degrada1:
                     #ifdef ALLEGRO_DOS
                      for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; for (j=0;j<y;j++) aux->line[j][i]= ((j>>3)%16)+240; }
                     #endif
                     #ifndef ALLEGRO_DOS
                      for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; for (j=0;j<y;j++) _putpixel(aux,i,j,((j>>3)%16)+240); }
                     #endif
                     break;
      case degrada2:
                     #ifdef ALLEGRO_DOS
                      for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; for (j=y;j<94;j++) aux->line[j][i]= ((j>>3)%16)+240; }
                     #endif
                     #ifndef ALLEGRO_DOS
                      for (i=0;i<tam;i++){ y=(buffer[i*inc]>>2)+14; for (j=y;j<94;j++) _putpixel(aux,i,j,((j>>3)%16)+240); }
                     #endif
                     break;
     }//fin del switch tipo
     vsync();
     switch (anchoX){
      case 320: blit(aux,screen,0,0,0,52,aux->w,aux->h); break;
      case 640: blit(aux,screen,0,0,200,152,aux->w,aux->h); break;
     }
    }//fin del if aux
   }//fin del if nulo
  }
  
 /**********************************************/
 void MostrarPortada(){
  //Muestra la Portada visual y saca sonido al exterior
  SAMPLE *auxSonido=NULL;
  BITMAP *auxFoto=NULL;
  auxSonido= datos_graficos[SONIDO_PORTADA].dat;
  auxFoto= datos_graficos[FOTO_PORTADA].dat;
  PuertoSerie(puerto_com,TRUE); //Activo el PTT
   rest(parametroEsperaPTT);
   play_sample(auxSonido,255,127,1000,FALSE);
   fade_out(1);
   clear_bitmap(screen);
   set_palette(black_palette);
   stretch_blit(auxFoto,screen,0,0,auxFoto->w,auxFoto->h,0,0,anchoX,altoY);
   fade_in(datos_graficos[PALETA_PORTADA].dat,1);
   rest(3000); //Espero 2 segundos
   fade_out(1);
   stop_sample(auxSonido);
   auxFoto=NULL;
   auxSonido= NULL;
  PuertoSerie(puerto_com,FALSE); //Desactivo el PTT
 }
#endif
