/*

VCap C++ Allegro Video Capture Library
Copyright (C) AKX 2004.

Version 0.1 (First Public Release)

VCap is free software (as in a bird flying freely), but if you use VCap in your
programs, I would appreciate a mention by the lines of Powered by VCap by AKX
in credits, documentation or elsewhere.


If you use MingW, use the following includes in your software.
*/
#include <allegro.h>
#include <winalleg.h>
#include "vfwmod.h"


class VCap
{
    private:
        HWND captureWindow;
        int width;
        int height;
        bool online;

        bool _start(int pWidth,int pHeight,int driver,int debug)
        {
           
            if(online) return false;
            width=pWidth;
            height=pHeight;
            captureWindow = capCreateCaptureWindow("VCapCaptureWindow", (debug?WS_VISIBLE:0), 0, 0, width, height, HWND_DESKTOP, 0);
            if(captureWindow==NULL) return false;
			//SendMessage(captureWindow, WM_CAP_DRIVER_CONNECT, 0, 0);
			capDriverConnect(captureWindow,driver);
			capPreview(captureWindow,FALSE);
			//SendMessage(captureWindow, WM_CAP_SET_PREVIEW, 0, 0);            
			online=true;
			return true;
        }         
        
    public:
        VCap()
        {
            online=false;
        }  
        
        void outputFormat()
        {
            BITMAPINFO bi;
            
            if(online)
            {
                capGetVideoFormat(captureWindow,&bi,sizeof(bi));
                printf("bi.bmiHeader.biSize=%d\n",bi.bmiHeader.biSize);
                printf("bi.bmiHeader.biWidth=%d\n",bi.bmiHeader.biWidth);                
                printf("bi.bmiHeader.biHeight=%d\n",bi.bmiHeader.biHeight);                                
            }    
        }   
        
        int getWidth()
        {
            BITMAPINFO bi;
            if(online)
            {
                capGetVideoFormat(captureWindow,&bi,sizeof(bi));
                return bi.bmiHeader.biWidth;                
            }              
            return 0;
        }     
        int getHeight()
        {
            BITMAPINFO bi;
            if(online)
            {
                capGetVideoFormat(captureWindow,&bi,sizeof(bi));
                return bi.bmiHeader.biHeight;                
            }              
            return 0;
        }
        
        void setRate(int msec)
        {
            if(online) capPreviewRate(captureWindow,msec);
        }         
        
        void videoSettings()
        {
            if(online) capDlgVideoSource(captureWindow);
        }   
        void formatSettings()
        {
            if(online) capDlgVideoFormat(captureWindow);
        }          
        
        bool start(int pWidth,int pHeight,int driver=0,int debug=0)
        {
            return _start(pWidth,pHeight,driver,debug);
        }    
        
        void stop()
        {
            if(online)
            {
                SendMessage(captureWindow, WM_CAP_DRIVER_DISCONNECT, 0, 0);
                online=false;
            }
        }    
        
        bool getFrame(BITMAP *bmp)
        {
            HBITMAP wbmp;
            BITMAP *tbmp;
            if(!online) return false;
       			
			capGrabFrame(captureWindow);
			capEditCopy(captureWindow);
			OpenClipboard(NULL);
			wbmp=(HBITMAP)GetClipboardData(CF_BITMAP);
			CloseClipboard();
			if(wbmp==NULL) return false;
			tbmp=convert_hbitmap_to_bitmap(wbmp);
			blit(tbmp,bmp,0,0,0,0,width,height);
			destroy_bitmap(tbmp);
			return true;
        }                 
};
