/*
This file is part of "UFO 2000" aka "X-COM: Gladiators"
                    http://ufo2000.sourceforge.net/
Copyright (C) 2000-2001  Alexander Ivanov aka Sanami
Copyright (C) 2002       ufo2000 development team

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "stdafx.h"

#include "global.h"
#include "packet.h"

char *Packet::strCommand[COMMAND_NUM] = {
	"NOTE", "QUIT", "TURN", "DOOR", "POSE", "PRIM", "UNLO", "LOAD", "TAKE", "DROP", 
	"MOVE", "FACE", "THRU", "BEAM", "FIRE", "ADUN", "PDSZ", "PDAT", "SEUN", "DEUN", 
	"MDAT", "STRT", "REST", "PNCH", "AMTR", "TLIM", "TCRC", "ELEV", "SCEN", "RULE",
	"OPTN", "PANI", "MORL", "RTIM", "P2ST", "EQUI"
};

Packet::Packet()
{
	reset();
}

void Packet::reset()
{
	cur = 0; size = 0;
	memset(data, 0, sizeof(data));
}

void Packet::create(char *header)
{
	reset();
	ASSERT(strchr(header, '_') == NULL);
	int len = sprintf(data + size, "%s_", header);
	size += len;
}

void Packet::create(Command cmd)
{
	reset();
	int len = sprintf(data + size, "_Xcom_%s_", strCommand[(int)cmd]);
	size += len;
}

//01234567890123
//23_Xcom_TURN_
//		  8	2
//^		 ^	^
//pkt - buf
Command Packet::command(char *buf, int buf_size)
{
	memset(data, 0, sizeof(data));
	cur = 0;
	if (strstr(buf, "_Xmes_") != NULL) {
		strcpy(data, strstr(buf, "_Xmes_") + 6);
		return CMD_MESSAGE;
	}

	if (strstr(buf, "_Xcom_") != NULL)
		for (int i = 0; i < COMMAND_NUM; i++) {
			char *xcom = strstr(buf, "_Xcom_");
			char *pkt = NULL;
			if (!memcmp(xcom + strlen("_Xcom_"), strCommand[i], strlen(strCommand[i])))
				pkt = strstr(buf, strCommand[i]);

			if (pkt != NULL) {
				int data_start = pkt + strlen(strCommand[i]) + 1 - buf;
				memcpy(data, buf + data_start, buf_size - data_start);
				size = buf_size - data_start;
				return (Command)i;
			}
		}
	return CMD_NONE;
}

void Packet::push(char *buf, int buf_size)
{
	for (int n = 0; n < buf_size; n++)
		data[size++] = buf[n];
	data[size++] = '_';
}

void Packet::pop(char *buf, int buf_size)
{
	for (int n = 0; n < buf_size; n++)
		buf[n] = data[cur++];
	cur++;
}

Packet &Packet::operator<<(char *i)
{
	ASSERT(strchr(i, '_') == NULL);
	int n = 0;
	while (i[n])
		data[size++] = i[n++];
	data[size++] = '_';
	return *this;
}

Packet &Packet::operator>>(char *i)
{
	int n = 0;
	while (data[cur] != '_')
		i[n++] = data[cur++];
	i[n] = 0; cur++;
	return *this;
}

Packet &Packet::operator<<(const std::string &x)
{
	for (int i = 0; i < (int)x.size(); i++) {
		if (x[i] == '_' || x[i] == '\\') {
			data[size++] = '\\';
			data[size++] = x[i];
		} else if (x[i] == '\n') {
			data[size++] = '\\';
			data[size++] = 'n';
		} else if (x[i] < 0x20) {
			sprintf(&data[size], "\\%02X", (uint8)x[i]);
			size += 3;
		} else {
			data[size++] = x[i];
		}
	}
	data[size++] = '_';
	return *this;
}

Packet &Packet::operator>>(std::string &x)
{
	x = "";

	while (data[cur] != '_') {
		if (data[cur] == '\\') {
			cur++;
			if (data[cur] == '\\') {
				x.append("\\");
				cur++;
			} else if (data[cur] == '_') {
				x.append("_");
				cur++;
			} else if (data[cur] == 'n') {
				x.append("\n");
				cur++;
			} else {
				int c;
				sscanf(&data[cur], "%2X", &c);
				x += (char)c;
				cur += 2;
			}
		} else {
			x += data[cur++];
		}
	}
	cur++;
	return *this;
}

Packet &Packet::operator<<(int i)
{
	int len = sprintf(data + size, "%d_", i);
	size += len;
	return *this;
}

Packet &Packet::operator>>(int &i)
{
	sscanf(data + cur, "%d_", &i);

	int len = 0;
	while (data[cur + len] != '_')
		len++;

	cur += len + 1;
	return *this;
}

Packet &Packet::operator<<(uint32 i)
{
    unsigned long x = i;
	int len = sprintf(data + size, "%08lX_", x);
	size += len;
	return *this;
}

Packet &Packet::operator>>(uint32 &i)
{
    unsigned long x;
	sscanf(data + cur, "%lX_", &x);
    i = (uint32)x;

	int len = 0;
	while (data[cur + len] != '_')
		len++;

	cur += len + 1;
	return *this;
}

Packet &Packet::operator<<(REAL i)
{
	ASSERT(sizeof(i) == sizeof(long));
	int len = sprintf(data + size, "%lx(%f)_", *(long *) & i, i);
	size += len;
	return *this;
}

Packet &Packet::operator>>(REAL &i)
{
	ASSERT(sizeof(i) == sizeof(long));
	sscanf(data + cur, "%lx", (long *) & i);
	int len = 0;
	while (data[cur + len] != '_')
		len++;

	cur += len + 1;
	return *this;
}

BQ::BQ(int sz) {
}

BQ::~BQ() {
}

void BQ::put(const std::string &str)
{
	bq.push_back(str);
}

void BQ::put(char *buf, int buf_size)
{
	bq.push_back(std::string(buf, buf_size));
}

int BQ::get(std::string &str)
{
	if (bq.empty()) return 0;

	str = bq.front();
	bq.pop_front();
	return 1;
}

int BQ::get(char *buf, int &buf_size)
{
	if (bq.empty()) return 0;

	buf_size = bq.front().size();
	memcpy(buf, bq.front().data(), buf_size);
	buf[buf_size] = 0;
	bq.pop_front();
	return 1;
}
