/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          vehicle.cc
 *
 *          vehicle related functions for the electron server
 */

#include "server/globals.h"
#include "server/actors/sweaponsmith.h"
#include "server/events/selfdestruct_ev.h"
#include "server/message.h"

int do_bomb_vehicle(Splayer *pl, Packet_command *pc)
{
    Atom *a = pl->get_atom();
    Sweaponsmith *ws;
    Repair_vehicle *rv;
    Sammo_pad *sap;
    Electron *e;
    Vehicle *v;
    char buf[80];
    
    ASSERT(a);
    
    // check if we're on an ammopad
    e = a->find_type(ACTOR_AMMO_PAD);
    sap = dynamic_cast<Sammo_pad *>(e);
    
    if (sap)
    {
	// find the weaponsmith connected to the ammopad
	rv = sap->get_repair_vehicle();

	// cast it up to weaponsmith from repair_vehicle
	ws = dynamic_cast<Sweaponsmith *>(rv);
    }
    
    // both have to exist, or no go
    if (!sap || !ws)
    {
	message(pl, "There is no weaponsmith around.");
	return 0;
    }

    // find the vehicle the player wants rigged
    v = (Vehicle *)a->find(pc->arg1, pc->arg2);
    if (!v)
    {
	ssprintf(buf, 80, "No such vehicle to rig (type %d, id %d).",
		 pc->arg1, pc->arg2);
	message(pl, buf);
	return 0;
    }
    
    if (!ws->bomb(v))
    {
	message(pl, "Vehicle is already rigged.");
	return 0;
    }

    ssprintf(buf, 80, "Your vehicle (%s) is now rigged.",
	     v->type_name);
    message(pl, buf);
    
    return 1;
}

// activate the selfdestruct sequence of a vehicle if possible
int do_self_destruct(Splayer *pl, Packet_command *pc)
{
    Atom *a = pl->get_atom();
    Vehicle *v;
    char buf[80];
    
    ASSERT(a);

    // find the vehicle
    v = (Vehicle *)a->find(pc->arg1, pc->arg2);
    if (!v)
    {
	ssprintf(buf, 80, "No such vehicle to selfdestruct (type %d, id %d).",
		 pc->arg1, pc->arg2);
	return 0;
    }

    // check ownership
    if (!pl->get_user()->is_owner(v))
    {
	message(pl, "You don't control that vehicle");
	return 0;
    }
    
    // check for a bomb
    if (!v->bomb)
    {
	message(pl, "Your vehicle is not rigged.");
	return 0;
    }

    // we're all set. boom.
    evl->add_event(new_selfdestruct_event(v), 1000);
    ssprintf(buf, 80, "This %s will selfdestruct in %d seconds.",
	     v->type_name, 10);
    message(pl, buf);
    return 1;
}
