/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       usercomm.h
 *
 *       'user commands'
 *
 *       declarations of all the do_???(User *, Packet_command *) functions
 *       each do_??? function performs one command, for example
 *       'enter this tank', or 'drop this weapon'
 */

#ifndef _USERCOMM_H_
#define _USERCOMM_H_

#include "s_common.h"
#include "user.h"

// pickup and drop functions
extern void do_enter(Splayer *pl, Packet_command *pc);
extern void do_exit(Splayer *pl, Packet_command *pc);
extern void do_drop(Splayer *pl, Packet_command *pc);
extern void do_pickup(Splayer *pl, Packet_command *pc);
extern void do_put_in(Splayer *pl, Packet_command *pc);
extern void do_get_from(Splayer *pl, Packet_command *pc);

// utility functions for command packets
extern Electron *find_acting_electron(Splayer *pl, Packet_command *pc);
extern Electron *find_target_electron(Splayer *pl, Packet_command *pc);

// move functions
extern int do_turn(Splayer *pl, Packet_command *pc);
extern int do_turn_vehicle(Splayer *pl, Packet_command *pc, Vehicle *v);
extern int do_move_dir(Splayer *pl, Packet_command *pc);
extern int do_move_player_dir(Splayer *pl, Packet_command *pc);
extern int do_move_vehicle_dir(Splayer *pl, Packet_command *pc, Vehicle *v);
extern int do_move_electron(Electron *e, int x, int y, int time);
extern int do_move_electron(Electron *e, Atom *a, int time);
extern Atom *get_target_atom(Electron *e, int x, int y);
extern int check_cyclewall(Electron *e, Atom *a);
// compute coordinates of the atom to the <dir>
extern int get_dir_coordinates(Electron *e, int dir, int *x, int *y);
extern int random_push(Electron *e);
extern Atom *check_adjacent_atom(Electron *parent, Electron *to_drop, int counter);
    
// door functions
extern int is_adjacent(Electron * one, Electron *two);
extern int do_open(Splayer *pl, Packet_command *pc);
extern int do_close(Splayer *pl, Packet_command *pc);
extern int do_lock(Splayer *pl, Packet_command *pc);
extern int do_unlock(Splayer *pl, Packet_command *pc);

// fire functions
extern int do_fire_to(Splayer *pl, Packet_command *pc);
extern int do_fire_dir(Splayer *pl, Packet_command *pc);
extern int do_fire_at(Splayer *pl, Packet_command *pc);
extern int do_lay_mine(Splayer *pl, Packet_command *pc);

// debug function to print location of an electron
extern void print_pos(Electron *e);

// game functions (voting, gametime, weapon selection?)
extern int do_vote(Splayer *pl, Packet_command *pc);
extern int do_gametime(Splayer *pl, Packet_command *pc);
extern int do_choose_weapon(Splayer *pl, Packet_command *pc);

// vehicle functions
extern int do_bomb_vehicle(Splayer *pl, Packet_command *pc);
extern int do_self_destruct(Splayer *pl, Packet_command *pc);

#endif
