/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       user.h
 *
 *       class definition of a User (player) for the Electron server
 *       the only reason this class is called User is that the Player
 *       class already exists in the common library.
 */

#ifndef _USER_H_
#define _USER_H_

#include "s_common.h"
#include "actors/sactors.h"
#include "handshake.h"

// maximum number of packets to be sent in one gameloop
#define MAX_PACKETS 100

class User : public Object
{
public:
    User();
    ~User();

    void set(Plug *p);
    void clear();
    
    void set_plug(Plug *p);
    Plug *get_plug();

    void set_player(Splayer *p);
    Splayer *get_player();

    void send_queue_packet(Packet *p);
    void send_queue();
    Packet *read_queue_packet();
    void read_queue();

    List *get_send_queue();
    
    void process_packet(Packet *p);
    void process_command_packet(Packet_command *pc);
    void system_message(Packet *p);
    void hangup();
    
    int is_owner(Electron *e);
    int set_info_allowed(Electron *e, Packet *p);
    int set_int_allowed(Electron *e, int var_id);
    int set_string_allowed(Electron *e, int var_id);
    int set_vector_allowed(Electron *e, int var_id);

    // functions to handle the time spent with doing commands
    int time_spent() const;        // how much time did we spend
    void set_time_spent(int ts);   // used to reset spent
    void spend_time(int how_much); // spend an amount of time

    // functions to check if the plug is in the fork
    void set_in_fork(int yesno);
    int get_in_fork();

    // functions for voting
    void set_vote(int v);
    int get_vote() const;

    // functions for weapon selection
    void set_weapon(int w);
    int get_weapon() const;
    
    int state;

protected:
    Plug *plug;
    Splayer *player;
    
    List send_q;
    List read_q;
    
    int system_priviliges;
    int spent;
    int blocked;
    int vote;
    int weapon;
    
    int in_fork;

    int bounce_next;
};

User *new_user(Plug *p);

#endif

 
