#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>

void printval(timeval *start, int n)
{
    timeval now;
    long dend, dstart;
    double val;
    
    gettimeofday(&now, 0);

    dstart = (1000000 * start->tv_sec + start->tv_usec);
    dend = (1000000 * now.tv_sec + now.tv_usec);

    val = (dend - dstart) / (double)n;
    
    printf("%lf\n", val);
}

int main()
{
    timeval start;
    timeval interval;

    interval.tv_sec = 0;
    
    printf("timing select(100): \n");

    gettimeofday(&start, 0);
    
    for (int i = 0; i < 200; i++)
    {
	interval.tv_usec = 100;
	select(0, 0, 0, 0, &interval);
    }

    printval(&start, 200);

    printf("timing select(1000): \n");
    
    gettimeofday(&start, 0);
    
    for (int i = 0; i < 200; i++)
    {
	interval.tv_usec = 1000;
	select(0, 0, 0, 0, &interval);
    }

    printval(&start, 200);

    printf("timing select(10000): \n");
    
    gettimeofday(&start, 0);
    
    for (int i = 0; i < 200; i++)
    {
	interval.tv_usec = 10000;
	select(0, 0, 0, 0, &interval);
    }

    printval(&start, 200);

    printf("timing select(20000): \n");
    
    gettimeofday(&start, 0);
    
    for (int i = 0; i < 200; i++)
    {
	interval.tv_usec = 20000;
	select(0, 0, 0, 0, &interval);
    }

    printval(&start, 200);

    printf("timing select(30000): \n");
    
    gettimeofday(&start, 0);
    
    for (int i = 0; i < 200; i++)
    {
	interval.tv_usec = 30000;
	select(0, 0, 0, 0, &interval);
    }

    printval(&start, 200);
    
    return 1;
}

