/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *    sv_utils.cc
 *
 *    various utility functions specific to the Electron server
 */
 
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include "common/utils.h"

#define BUFSIZE    1024

void warning(char const *fmt, ...)
{
    char buf[BUFSIZE];
    va_list args;
    va_start( args, fmt );
    vsprintf( buf, fmt, args );
    fprintf(stderr, "%s: %s\n", progname, buf);
    va_end(args);
}

void fatal(char const *fmt, ...)
{
    char buf[BUFSIZE];
    va_list args;
    va_start( args, fmt );
    vsprintf( buf, fmt, args );
    fprintf(stderr, "%s: %s\n", progname, buf);
    va_end(args);

#ifdef DEBUGMODE
    abort();
#endif

    exit(1);
}

// print file and line no, then dump core.
// use ASSERT macro to check obvious conditions,
// do not call this directly.
void common_assert(char const *file, int line)
{
    warning("%s:%d: ASSERT failed", file, line);
    abort();
}
