/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        send_q.cc
 *
 *        definition of network queue functions for the Electron server
 */

#include "send_q.h"
#include "globals.h"
#include "common/fork.h"

// List global_send_queue;

Fork global_send_queue;

void send_queue_packet(Packet *p)
{
    global_send_queue.push(p);
}

void send_queues()
{
    int size = fb.get_nr_plugs();
//    Packet *p;
    
    // empty all personal send queues
    for (int i = 0; i < size; i++)
    {
	if (fb[i])
	{
	    if (users[i]->state == SHAKE_PLAYING)
		users[i]->send_queue();
	}
    }

    // using Fork it is no longer necessary to explicitly empty
    // the global send queue: it is split up into the individual queues
/*    
    // empty the global send queue
    while ((p = (Packet *)global_send_queue.pop_tail()))
    {
	for (int i = 0; i < size; i++)
	{
	    if (fb[i] && users[i].state == SHAKE_PLAYING)
	    {
		if (p->write_to(fb[i]) < 0)
		{
		    warning("send_queues : connection %d unconcious!", i);
		    warning("send_queues : killing user %d", i);

		    users[i].hangup();
		}
	    }
	}

	delete_object(p);
    }
*/
    
}

void packet_to_queue(Packet *p, Object *_l)
{
    List *l = (List *)_l;

    l->push(p);
}
