/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        tools.h
 *
 *        utility functions for the lexer and parser,
 *        for example to extract a coordinate pair from a string,
 *        to get an actor type from a name, and so on.
 */

#ifndef _PARSER_TOOLS_H_
#define _PARSER_TOOLS_H_

#include "common/list.h"
#include "common/vector.h"
#include "common/electron.h"

extern List current_atom;
extern List current_electron;
extern List references;
extern List labels;

extern int map_name_set;
extern int start_point_set;
extern int vote_point_set;
extern int comments_eaten;

extern char * map_actor_types[];

extern int  init_map_actor_types();
extern void shutdown_map_actor_types();

extern char *underscore_name(int actor_type);

extern void set_lattice_size(Vector *v);
extern void set_start_point(Vector *v);
extern void set_vote_point(Vector *v);
extern void set_map_name(char const *str);
extern int  check_file();
extern int  check_range(Vector *v);
extern int  check_type(int actor_type);
extern int  string_to_type(char const *str);

extern void begin_atom(Vector *v);
extern void end_atom();

extern void begin_electron(int actor_type);
extern void end_electron();

extern void add_label(char const *str);
extern void add_reference(char const *str);

extern int fix_references();
extern int connect(Electron *vehicle, Electron *key);

#endif
