%{

    /*
     *
     *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
     *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
     *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
     *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
     *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
     *
     *                           copyright 1999
     *                  Martijn Versteegh & Hein Zelle
     *
     */

    /*
     *         rules.lex
     *
     *         lexer rules for the Electron map parser
     */

    // implement this lexer function
    #define YY_DECL int Lexer::yylex()

    // include parser header (which includes lexer header)
    #include "parser.h"
    
    // make a dummy yylex function for yyFlexLexer
    int yyFlexLexer::yylex()
    {
	return 0;
    }
    
%}

    // tokens

%option yylineno
%option noyywrap

%x comment

eoln_comment     "//".*
any_char         .|\n
integer          [0-9]+
ws               [ \t]
identifier       [a-zA-Z_][a-zA-Z0-9_]*
size             [sS][iI][zZ][eE]
start            [sS][tT][aA][rR][tT]
vote             [vV][oO][tT][eE]
name             [nN][aA][mM][eE]
string           \"[^\"]*\"
for              [fF][oO][rR]
tag              [tT][aA][gG]

%%

    /* rules section */

    /* ignore comments */
{eoln_comment}        comments_eaten++;
"/*"                  {
                          comments_eaten++;
                          BEGIN(comment);
                      }
<comment>{any_char}   ;              /* do nothing */
<comment>"*/"         BEGIN(INITIAL);

    /* block braces */
"{"                   {
////                          TRACE("_ {");
			  return (Parser::OPEN_BRACE);
                      }

"}"                   {
//                          TRACE("_ }");
			  return (Parser::CLOSE_BRACE);
                      }

    /* coordinate pair */
"<"                   {
                          return (Parser::OPEN_BRACKET);
                      }

">"                   {
                          return (Parser::CLOSE_BRACKET);
                      }

{integer}             {
                          return (Parser::INTEGER);
                      }

","                   {
                          return (Parser::COMMA);
                      }

    /* literal keyword 'size' */
{size}                {
//                          TRACE("_ size");
			  return (Parser::SIZE);
                      }

    /* literal keyword 'start' */
{start}               {
//                          TRACE("_ start");
                          return (Parser::START);
                      }

    /* literal keyword 'vote' */
{vote}                {
//                          TRACE("_ vote");
                          return (Parser::VOTE);
                      }

    /* literal keyword 'name' */
{name}                {
//                          TRACE("_ name");
                          return (Parser::NAME);
                      }

{tag}                 {
//                          TRACE("_ tag");
                          return (Parser::TAG);
                      }

{for}                 {
//                          TRACE("_ for");
                          return (Parser::FOR);
                      }

    /* identifier (actor_type) */
{identifier}          {
//                          TRACE("_ id");
                          return (Parser::IDENTIFIER);
                      }

    /* quoted string */
{string}              {
//                          TRACE("_ string");
                          return (Parser::STRING);
                      }

    /* semicolon */
;                     {
//                          TRACE("_ ;");
                          return (Parser::SEMICOLON);
                      }

    /* dump whitespace and newlines */
{ws}+                 ;
\n                    ;

<<EOF>>               {
//                          TRACE("_ <<EOF>>");
                          return (Parser::STOP);
                      }

    /* something doesn't fit these rules? we found an error */
.                     {
                          error();
			  return (Parser::ABORT);
                      }
