/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        reference.cc
 *
 *        class definition of a Reference
 */

#include "reference.h"

Reference::Reference(Electron *new_e, char const *new_name)
{
    e = new_e;
    name = sstrdup(new_name);
}

Reference::~Reference()
{
    delete name;
    name = 0;
}

char const *Reference::get_name() const
{
    return name;
}

Electron *Reference::get_e() const
{
    return e;
}
