/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *         lexer.h
 *
 *         class definition of the Lexer class, derived of yyFlexLexer
 *
 *         lexer rules are in the file rules.lex
 */

#ifndef _ELECTRON_LEXER_H_
#define _ELECTRON_LEXER_H_

#include <FlexLexer.h>
#include <fstream.h>
#include <stdlib.h>

class Lexer : public yyFlexLexer
{
public:
    Lexer();                           // construct with an opened file
    void set_yyin(istream *new_yyin);  // assign a new yyin stream
    
    int yylex();                       // overload from yyFlexLexer
    void error();                      // print warning and exit
    int lineno();                      // return yylineno
private:
};

#endif
