/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       lexer.cc
 *
 *       class implementation of Lexer, derived of yyFlexLexer
 *       yylex() is implemented by flex++
 */

#include <stdio.h>
#include "lexer.h"
#include "../../common/utils.h"

Lexer::Lexer()
{
    // nothing to do
}

void Lexer::set_yyin(istream *new_yyin)
{
    switch_streams(new_yyin, yyout);
}

// error found in input file
// print a warning and stop the lexer (done in rules.lex)
void Lexer::error()
{
    warning("Lexer : unrecognized text at line %d", lineno());
    warning("offending text: %s", yytext);
}

int Lexer::lineno()
{
    return yylineno;
}
