/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        label.cc
 *
 *        class definition of a Label
 */

#include "label.h"

Label::Label(Electron *new_e, char const *new_name)
{
    e = new_e;
    name = sstrdup(new_name);
}

Label::~Label()
{
    delete name;
    name = 0;
}

char const *Label::get_name() const
{
    return name;
}

Electron *Label::get_e() const
{
    return e;
}
