/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        openclose.cc
 *
 *        server functions to close and open doors
 */

#include "globals.h"
#include "message.h"
#include "usercomm.h"

Sdoor *find_door(Splayer *pl, Packet_command *pc)
{
    int
	x,
	y;
    
    Atom *a;

    if (!get_dir_coordinates(pl, pc->arg1, &x, &y))
    {
	return 0;
    }

    warning("target coordinates: <%d, %d>", x, y);
    
    a = lattice->get(x, y);

    if (!a)
    {
	warning("no atom found at <%d, %d>", x, y);
	return 0;
    }
    
    if (!a->top_level_object)
    {
	warning("atom at <%d, %d> has no top level object!", x, y);
	return 0;
    }

    if (a->top_level_object->actor_type != ACTOR_DOOR)
    {
	warning("top level object at <%d, %d> is not a door. (%s)",
		x, y, a->top_level_object->type_name);
	return 0;
    }

    return (Sdoor *)(a->top_level_object);
}

int do_open(Splayer *pl, Packet_command *pc)
{
    Sdoor *d = find_door(pl, pc);

    if (!d)
    {
	message(pl, "You don't see a door there.");
	return 0;
    }

    return d->open(pl);
}

int do_close(Splayer *pl, Packet_command *pc)
{
    Sdoor *d = find_door(pl, pc);

    if (!d)
    {
	message(pl, "You don't see a door there.");
	return 0;
    }

    return d->close(pl);
}

int do_lock(Splayer *pl, Packet_command *pc)
{
    Sdoor *d = find_door(pl, pc);

    if (!d)
    {
	message(pl, "You don't see a door there.");
	return 0;
    }

    return d->lock(pl);
}

int do_unlock(Splayer *pl, Packet_command *pc)
{
    Sdoor *d = find_door(pl, pc);

    if (!d)
    {
	message(pl, "You don't see a door there.");
	return 0;
    }

    return d->unlock(pl);
}

int is_adjacent(Electron * one, Electron *two)
{
    int
	x1,
	x2,
	y1,
	y2;

    one->get_pos(&x1, &y1);
    two->get_pos(&x2, &y2);

    if (
	(abs(x1 - x2) == 1 && y1 == y2)
	||
	(abs(y1 - y2) == 1 && x1 == x2)
	)
	return 1;

    return 0;
}
