/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        message.cc
 *
 *        functions to send messages to the client
 */

#include "globals.h"

char const *error_message = 0;

void message(User *u, char const *m)
{
    u->send_queue_packet(new_packet_info_string(ACTOR_SYSTEM,
						SYS_MESSAGE,
						System::STC_MESSAGE,
						m));
}

void message(Splayer *pl, char const *m)
{
    User *u;

    u = pl->get_user();

    if (!u)
    {
	warning("message: player doesn't have a user");
	return;
    }

    message(u, m);
}

void message_all(char const *m)
{
    send_queue_packet(new_packet_info_string(ACTOR_SYSTEM,
					     SYS_MESSAGE,
					     System::STC_MESSAGE,
					     m));
}

void check_error_message(Splayer *pl)
{
    if (error_message)
    {
	message(pl, error_message);
	error_message = 0;
    }
}
