/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *      make_map.cc
 *
 *      generate a lattice
 */

#include "globals.h"
#include "parser/parser.h"

void add_room(int x, int y, int actor_id)
{
    Atom *a = new_atom();
    Ssimple_room *sr = new_actor<Ssimple_room>(actor_id);
    
    lattice->set(a, x, y);
    lattice->add(sr, x, y);

    // add the newly created room to the global storage
    storage->lowlevel_add(sr);
}

char *level[40] =
{
    "########################################### ",
    "#   #               # ##################### ",
    "#   ##############  # ##################### ",
    "#   #       #    #  # ##################### ",
    "#   #########    #  # ##################### ",
    "#   #       #    #  # #   #       #    #  # ",
    "#   #       ######  # #   #       #    #  # ",
    "#   ##########   #  # #   #       #    #  # ",
    "#   ###R##########  # #   #       #    #  # ",
    "#   ############    # #   #       #    #  # ",
    "#   #  #   #   #    # #   #       #    #  # ",
    "#   #  ## ##   #    # #   #  ## ##   #    # ",
    "#   #  # # #   #    # #   #  ## ##   #    # ",
    "#   #  #   #   #    # #   #  ## ##   #    # ",
    "#   #  #   #   #    # #   #  ## ##   #    # ",
    "#   ############    # #   #  ## ##   #    # ",
    "#   #  #   #  ##    # ##################### ",
    "#   ############    # ##################### ",
    "#      #            # ##################### ",
    "########################################### ",
    "##################### ##################### ",
    "#                   # ##################### ",
    "#   ##############  # ##################### ",
    "#   #       #    #  # ##################### ",
    "#   #########    #  # ##################### ",
    "#   #       #    #  # #   #       #    #  # ",
    "#   #       ######  # #   #       #    #  # ",
    "#   ##########   #  # #   #       #    #  # ",
    "#   ##############  # #   #       #    #  # ",
    "#   ############    # #   #       #    #  # ",
    "#   #  #   #   #    # #   #       #    #  # ",
    "#   #  ## ##   #    # #   #  ## ##   #    # ",
    "#   #  # # #   #    # #   #  ## ##   #    # ",
    "#   #  #   #   #    # #   #  ## ##   #    # ",
    "#   #  #   #   #    # #   #  ## ##   #    # ",
    "#   ############    # #   #  ## ##   #    # ",
    "#   #  #   #  ##    # ##################### ",
    "#   ############    # ##################### ",
    "#      #            # ##################### ",
    "########################################### "
};

int init_lattice()
{
    // set the global latice pointer
    lattice = new Lattice(44, 40);
    
    // pass the size of the lattice to the system actor
    // check if this goes ok with virtual function calls
    // no it isn't, so we add a cast. BLEURGH.
    ((Electron *)sys)->set_vector_var(System::MAP_SIZE, lattice->get_w(), lattice->get_h());
    sys->set_string_var(System::MAP_NAME, "test map");

    for (int y = 0; y < 40; y++)
    {
	for (int x = 0; x < 44; x++)
	{
	    if (level[y][x] == '#')
		add_room(x, y, Electron::fid());

	    if (level[y][x] == 'R')
	    {
		lattice->set_reset(x, y);
		add_room(x, y, Electron::fid());
	    }
	}
    }
	 
    return 1;
}    

int load_map(char const *filename)
{
    Parser *p;
    ifstream ifs(filename);

    if (!ifs)
    {
	warning("load_map: could not open %s", filename);
	return 0;
    }

    p = new Parser(&ifs);

    if (!(p->yyparse()))
    {
	warning("load_map: something went wrong loading %s", filename);
	delete p;
	return 0;
    }
    else
    {
	warning("load_map: succesfully loaded '%s'",
		filename);
	warning("          map size %d * %d, map name %s",
		lattice->get_w(), lattice->get_h(),		
		sys->get_string_var(System::MAP_NAME));
    }
    
    delete p;
    return 1;
}
