/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *     globals.h
 *
 *     global variables for the Electron server
 */

#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#include "s_common.h"
#include "user.h"
#include "s_freelist.h"
#include "send_q.h"
#include "create.h"
#include "inout.h"
#include "damage.h"
#include "events.h"
#include "actors/sactors.h"
#include "game/game.h"

// defines

#define MAX_PLAYERS 16

// variable declarations

extern Fusebox fb;
extern User *users[];

extern Atom *storage;
extern Atom *garbage;
extern System *sys;
extern Eventlist *evl;

extern Game *game;

// function declarations

int init_globals();                          // 0 = succes
void shutdown_globals();                             

void add_room(int x, int y, int actor_id);
int load_map(char const *mapname);
void send_lattice(int connection);
int game_loop();
int net_shake(int connection, int state);
int playing(int connection);                      // returns new SHAKE_STATE

#ifndef max
#define max(a, b) ((b) > (a) ? (b) : (a))
#endif

#ifndef min
#define min(a, b) ((b) < (a) ? (b) : (a))
#endif

#endif
