/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *     globals.cc
 *
 *     global variable definitions for the Electron server
 */

#include "globals.h"

// pas op: free_list code is nog niet geinitialiseerd!
// er mag nog nergens new_object of delete_object aangeroepen worden!

Fusebox fb;
User *users[MAX_PLAYERS + 1];

Eventlist *evl = 0;
Atom *garbage = 0;

Game *game = 0;

// 0 = succes
// initialize global pointer variables
int init_globals()
{
    sys = new_actor<Ssystem>(0);
    lattice = 0;
    evl = new Eventlist;
    garbage = new Atom;             // don't use freelist functions
    garbage->freelist_index = -1;   // prevent assert failure on deletion

    for (int u = 0; u < MAX_PLAYERS + 1; u++)
    {
	users[u] = 0;
    }

    // make a nogame object, and initialise global game with it
    set_no_game();
    
    return 0;
}

// delete global pointer variables
void shutdown_globals()
{
    if (game)
    {
	delete_object(game);
	game = 0;
    }

    if (sys)
    {
	delete_object(sys);
	sys = 0;
    }

    for (int u = 0; u < MAX_PLAYERS + 1; u++)
    {
	if (users[u])
	{
	    delete_object(users[u]);
	    users[u] = 0;
	}
    }
    
    if (lattice)
    {
	delete lattice;
	lattice = 0;
    }

    if (evl)
    {
	delete evl;
	evl = 0;
    }

    if (garbage)
    {
	delete garbage;
	garbage = 0;
    }
}
