/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          weapon.cc
 *
 *          functions to distribute weapons in the game.
 *          this may be either by loading a weapon machine and
 *          filling it with weapons, or by spreading weapons
 *          throughout the map.
 */

// weapon machine functionality: fill a weapon machine with weapons

#include "server/globals.h"
#include "server/actors/sweaponmachine.h"
#include "server/message.h"

int do_choose_weapon(Splayer *pl, Packet_command *pc)
{
    Atom *a = pl->get_atom();
    Sweaponmachine *wm;
    
    ASSERT(a);
    
    // check if there is a weaponmachine in the room
    if (!(wm = (Sweaponmachine *)a->find_type(ACTOR_WEAPONMACHINE)))
    {
	message(pl, "There is no weapon machine here.");
	return 0;
    }

    return wm->select_weapon(pl, pc);
}
