/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          vote.cc
 *
 *          all vote-related functions
 */

#include "server/globals.h"
#include "server/message.h"
#include "server/usercomm.h"
#include "server/game/vote.h"
#include "server/game/game.h"

// reset votes
void reset_votes()
{
    int size = fb.get_nr_plugs();
    
    for (int v = 0; v < GAME_LAST; v++)
    {
	game_type_list[v].votes = 0;
    }

    for (int i = 0; i < size; i++)
    {
        if (fb[i])
        {
            if (users[i]->state == SHAKE_PLAYING)
	    {
		users[i]->set_vote(0);
	    }
        }
    }
}

int do_vote(Splayer *pl, Packet_command *pc)
{
    User *u = pl->get_user();
    int vote = pc->arg1;
    int oldvote;
    char buf[80];
    
    ASSERT(u);

    // get old vote first, to print in the list
    oldvote = u->get_vote();

    // check for valid vote
    if (vote < 1 || vote >= GAME_LAST)
    {
	message(pl, "Invalid vote, valid choices are:");

	for (int v = 1; v < GAME_LAST; v++)
	{
	    if (oldvote == v)
		sprintf(buf, "[%2d] %s : %d *", v, game_type_list[v].name,
			game_type_list[v].votes);
	    else
		sprintf(buf, "[%2d] %s : %d", v, game_type_list[v].name,
			game_type_list[v].votes);
	    message(pl, buf);
	}
	return 0;
    }

    // check if we're in a vote room
    if (pl->parent->actor_type != ACTOR_VOTE_ROOM)
    {
	message(pl, "You can only vote in a vote room.");
	return 0;
    }

    // find a voting machine
    ASSERT(pl->get_atom());
    if (! pl->get_atom()->find_type(ACTOR_VOTEMACHINE))
    {
	message(pl, "You can only vote at a voting machine.");
	return 0;
    }

    if (oldvote == vote)
    {
	sprintf(buf, "You already voted for %s.",
		game_type_list[vote].name);
	message(pl, buf);
	return 0;
    }
    
    // if we have already voted, change our vote.
    if (oldvote)
    {
	ASSERT(game_type_list[oldvote].votes > 0);
	game_type_list[oldvote].votes--;
	
	sprintf(buf, "You change your vote from %s to %s.",
		game_type_list[oldvote].name,
		game_type_list[vote].name);
    }
    else
    {
	sprintf(buf, "You vote for %s.",
		game_type_list[vote].name);
    }
    
    u->set_vote(vote);
    game_type_list[vote].votes++;
    message(pl, buf);
    game->vote(pl);
    
    return 1;
}

int do_gametime(Splayer *pl, Packet_command *pc)
{
    char buf[256];
    Clock *cl;
    
    if (!game || !(cl = game->get_clock()))
    {
	message(pl, "No game is running, clock is offline.");
	return 0;
    }

    ssprintf(buf, 256,
	     "Game duration: %d seconds  Running for: %d seconds"
	     "  Remaining: %d seconds",
	     cl->get_length()/100, cl->get_timer()/100,
	     (cl->get_length() - cl->get_timer())/100);
    
    message(pl, buf);
    
    return 1;
}
