/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          twoteam.h
 *
 *          class declaration of Twoteam: a two team game
 *          this contains the specific information for a two team game,
 *          general stuff is contained in baseclass Game
 */

#ifndef _TWOTEAM_H_
#define _TWOTEAM_H_

#include "game.h"
#include "server/globals.h"

class Twoteam : public Game
{
public:
    Twoteam();
    void set();
    void set(Svotemachine *vm, Sweaponmachine *wm, Clock *cl);
    void clear();

    int init_game();
    int init_teams();
    void stop();
    
    // do not overload damage_player, there's no need
    // overload die_player to update the scores
    int die_player(Splayer *pl, Electron *k);
};

extern Twoteam *the_twoteam_game;
extern void start_twoteam_game();
extern Game *new_twoteam();

#endif
