/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          team.cc
 *
 *          class implentation of a Team, basically a list of players
 *          with score information
 */

#include "team.h"
#include "server/s_freelist.h"
#include "common/electron.h"
#include "server/actors/splayer.h"

Team::Team()
{
    freelist_index = SERVER_FREELIST_TEAM;
    set();
}

void Team::set()
{
    // reset everything
    clear();
}

void Team::clear()
{
    Splayer *pl;
    
    // clear all players' team pointers
    for (List::reset();
	 (pl = (Splayer *)List::get());
	 List::next())
    {
	pl->set_team(0);
	pl->set_running(0);
    }

    score = 0;
    List::clear();
}

Team *new_team()
{
    Team *t = (Team *)new_object(SERVER_FREELIST_TEAM);

    if (!t)
    {
	t = new Team();
    }

    t->set();

    return t;
}

void Team::push(Object *other)
{
    // make sure it's a player
    ASSERT(((Electron *)other)->actor_type == ACTOR_PLAYER);

    ((Splayer *)other)->set_team(this);
    List::push(other);
}
