/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          tag.h
 *
 *          class declaration of Tag: gametype to play tag.
 *          this class contains all functionality specific to this game type.
 *          general game information is contained in the base class Game
 */

#ifndef _TAG_H_
#define _TAG_H

#include "game.h"
#include "server/globals.h"

class Tag : public Game
{
public:
    Tag();
    void set();
    void set(Svotemachine *vm, Sweaponmachine *wm, Clock *cl);
    void clear();

    int init_game();
    int init_teams();
    int die_player(Splayer *pl, Electron *k);
    int damage_player(Splayer *pl, Splayer *bully);

    void stop();
};

extern Tag *the_tag_game;
extern void start_tag_game();
extern Game *new_tag();

#endif
