/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          tag.cc
 *
 *          class implementation of Tag, a game type to play tag
 */

#include "tag.h"
#include "server/message.h"
#include "server/usercomm.h"

// allocate a tag game
Game *new_tag()
{
    Tag *t;

    t = (Tag *) new_object(SERVER_FREELIST_TAG_GAME);

    if (!t)
    {
	t = new Tag();
    }

    t->set();
    return t;
}

Tag::Tag()
{
    freelist_index = SERVER_FREELIST_TAG_GAME;
    game_type = TAG_GAME;
    set();
}

void Tag::set()
{
    // request 2 teams for playing tag
    Game::set(0, 0, 0, 2);

    // duration : 10 minutes
    duration = 10 * 60 * 100;
}

void Tag::set(Svotemachine *vm, Sweaponmachine *wm, Clock *cl)
{
    // request 2 teams for playing tag
    Game::set(vm, wm, cl, 2);
}

void Tag::clear()
{
    Game::clear();
}

int Tag::init_game()
{
    // choose a player to be 'it' (het bokje)
    if (!init_teams())
	return 0;

    char buf[256];
    sprintf(buf, "Tag: game initialised: %s %d is IT!",
	    ((Splayer *)teams[0]->get_head())->type_name,
	    ((Splayer *)teams[0]->get_head())->actor_id);
    message_all(buf);
    
    return 1;
}

int Tag::init_teams()
{
    // pick a player to be 'it'
    // for now, all players join the fun

    // as soon as the voting machine is done, use the list of players
    // that voted.

    int t = 0;
    char buf[256];
    
    // select all players that are logged in and SHAKE_PLAYING
    for (int u = 0; u < MAX_PLAYERS; u++)
    {
	if (users[u] && users[u]->state == SHAKE_PLAYING)
	{
	    Splayer *pl = users[u]->get_player();
	    
	    if (t == 0)
	    {
		teams[0]->push(pl);
		sprintf(buf,
			"%s %d is IT! (tag-team)",
			pl->type_name, pl->actor_id);
		message_all(buf);
	    }
	    else
	    {
		teams[1]->push(pl);
		sprintf(buf,
			"%s %d is running! (running-team)",
			pl->type_name, pl->actor_id);
		message_all(buf);
	    }

	    t++;
	}
    }

    // check if we found enough players
    if (t < 2)
    {
	message_all("Tag: a minimum of 2 players is required");
	return 0;
    }

    return 1;
}

// custom die function for players
// handle personal and team scores
// damage has now been disabled in tag games,
// therefore dying should not be possible either.
int Tag::die_player(Splayer *pl, Electron *k)
{
//    int rx, ry;
//    Atom *a;
//    Splayer *killer;
    char buf[256];
//    Team *kt = 0;
//    Team *plt = 0;

    // do something fancy

    if (!k)
    {
	// killed by something other than a player.
	// this is a bug: players should not be able to receive damage
	// in this game.
	// return 0 to stop the dying from continuing

	warning("Tag::die_player : BUG: %s %d killed something not a player.",
		pl->type_name, pl->actor_id);
    }
    else
    {
	sprintf(buf, "Tag: %s %d killed by %s %d ?? BUG!!",
		pl->type_name, pl->actor_id,
		(k) ? k->type_name : "", (k) ? k->actor_id : 0);
	message_all(buf);

	// don't adapt kill scores: player was never supposed to die
    }
	
    // don't let the dying continue
    return 0;
}

// called whenever a player is damaged by another player
// in a tag game damage is used to 'tag' other players. However,
// don't deal real damage since we don't want players to die.
int Tag::damage_player(Splayer *pl, Splayer *bully)
{
    char buf[256];

    // check if bully exists
    // damage from non-players (such as mines) does not happen.
    // only vehicles and other non-players can get damaged.
    
    if (!bully)
	return 0;
    
    ASSERT(pl->get_team());
    ASSERT(bully->get_team());
    
    // check if bully is on the tag-team
    if (bully->get_team() == teams[0])
    {
	// check if player is on the running team
	if (pl->get_team() == teams[1])
	{
	    // notify players, and change team of pl
	    sprintf(buf,
		    "%s %d was tagged by %s %d!",
		    pl->type_name, pl->actor_id,
		    bully->type_name, bully->actor_id);
	    message_all(buf);
	    message(pl, "You're IT!!");
	    sprintf(buf, "You tagged %s %d",
		    pl->type_name, pl->actor_id);
	    message(bully, buf);
	    bully->get_team()->score++;

	    // change the team
	    teams[1]->pop(pl);
	    teams[0]->push(pl);
	}
    }

    // check if we should stop: team composition has changed
    check();
    
    // don't let the damage come through
    return 0;
}

void Tag::stop()
{
    char buf[1024];
    Splayer *winner;

    if (!running)
	return;

    sprintf(buf,
	    "Game stopped.\n"
	    "tag-team score: %d\n"
	    "running-team score: %d",
	    teams[0]->score,
	    teams[1]->score);
    message_all(buf);

    winner = (Splayer *)teams[1]->get_head();
    if (winner)
    {
	teams[1]->reset();
	while ((winner = (Splayer *)(teams[1]->get())))
	{
	    sprintf(buf,
		    "Winner: %s (%s %d)",
		    winner->get_string_var(Player::NAME),
		    winner->type_name,
		    winner->actor_id);
	    message_all(buf);

	    teams[1]->next();
	}
    }
    else
    {
	message_all("No runners survived.");
    }

    Game::stop();
}
