/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          nogame.h
 *
 *          class declaration of Nogame: an empty game
 *          this game can be active when no game is really active,
 *          to catch strange things like players dying outside of a game,
 *          and such.
 */

#ifndef _NOGAME_H_
#define _NOGAME_H_

#include "game.h"

class Nogame : public Game
{
public:
    Nogame();
    void set();
    void set(Svotemachine *vm, Sweaponmachine *wm, Clock *cl);
    void clear();

    int init_game();      // must be overloaded
    void announce();      // overload to make it do nothing

    // overload die_player and damage_player, we want
    // these ignored when there is no game going on
    // so they have to return 0
    int die_player(Splayer *pl, Electron *k);
    int damage_player(Splayer *pl, Splayer *bully);

    void vote(Splayer *pl);    // someone voted. start timer?
    void start_new_game();     // vote time is up. select a game and start it
    
protected:
    int voting_started;        // has it started yet?
    Game_event *ev;            // track this event in case we don't want it
                               // anymore
};

extern Game *new_nogame();

#endif
