/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          game.h
 *
 *          class declaration of Game
 *          Game is to be a baseclass for Gametype, which will contain
 *          specific information for each game type.
 *
 *          Game will contain all data and functions that the game types
 *          have in common.
 */

#ifndef _GAME_H_
#define _GAME_H_

#include "common/object.h"
#include "common/list.h"
#include "common/atom.h"
#include "team.h"
#include "server/actors/splayer.h"
#include "server/actors/sweaponmachine.h"
#include "server/actors/svotemachine.h"
#include "server/game/clock.h"

class Game;
class Clock;

struct game_type
{
    int type;
    char const *name;
    Game *(*fun)();
    int votes;
    int duration;
};

enum game_types
{
    NO_GAME = 0,
    TAG_GAME,
    TWOTEAM_GAME,
    GAME_LAST
};

extern game_type game_type_list[GAME_LAST];

class Game : public Object
{
public:
    Game();
    virtual void set();
    virtual void set(Svotemachine *vm, Sweaponmachine *wm, Clock *cl, int n_teams);
    virtual void clear();

    virtual int allowed_in_freelist() { return 1; }   // DO! recycle!

    // initialise game, 1 = succes, 0 = failure
    virtual int init_game() = 0;

    // call when a player dies so the game can handle it
    // provide a default for games that do not wish to overload it
    virtual int die_player(Splayer *pl, Electron *k);

    // call when a player is damaged so the game can handle it
    // provide a default for games that do not wish to overload it
    virtual int damage_player(Splayer *pl, Splayer *bully);

    virtual void check();               // check if we're finished

    virtual void vote(Splayer *pl);     // someone just voted, start timer?
    virtual void start_new_game();      // select a game from the vote table
    virtual void start();
    virtual void stop();
    virtual void warn();
    virtual void announce();

    int get_running() const;

    // find machines in the lattice
    Sweaponmachine *find_weapon_machine();
    Svotemachine *find_vote_machine();

    Clock *get_clock();
    
protected:
    Team **teams;                       // array of team *
    int nr_teams;
    
    List startpoints;                   // contains Atom *

    Atom *vote_area[2];                 // left bottom, right top
    
    Svotemachine *vote_machine;
    Sweaponmachine *weapon_machine;
    Clock *clock;
    
    int duration;                       // how long should the game last
    int running;
    int game_type;                      // what kind of game are we
};

// delete old game if necessary, install nogame
extern void set_no_game();

#endif
