/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          clock.h
 *
 *          class declaration of the game clock
 */

#ifndef _CLOCK_H_
#define _CLOCK_H_

#include "common/object.h"
#include "server/game/game.h"
#include "server/events/game_ev.h"

class Clock : public Object
{
public:
    Clock();

    virtual void set();
    virtual void set(unsigned int length);
    virtual void clear();

    void tick(int inc);             // advance a clock tick
    void start();                   // set event and start running
    void stop();                    // remove event and stop running

    void set_event(Game_event *_ev);
    Game_event *get_event();
    unsigned int get_length();
    unsigned int get_timer();
    
protected:
    unsigned int
        timer,
	length,
        countdown,
        countup;
    Game_event
        *ev;
};

Clock *new_clock(int length);

#endif
