/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          clock.cc
 *
 *          class implementation of the game clock
 */

#include "clock.h"
#include "server/globals.h"
#include "server/message.h"

Clock::Clock()
{
    freelist_index = SERVER_FREELIST_CLOCK;
    timer = 0;
    length = 0;
    countdown = 0;
    countup = 0;
    ev = 0;
}

void Clock::set()
{
    ASSERT(!ev);

    timer     = 0;
    length    = 30000;   // 5 minutes = 300 seconds
    countdown = 1000;    // 10 seconds
    countup   = 1000;    // 10 seconds
    ev        = 0;
}

void Clock::set(unsigned int _length)
{
    ASSERT(!ev);
    
    timer     = 0;
    countdown = 1000;
    countup   = 1000;
    length    = max(_length, countdown);
    ev        = 0;
}

void Clock::clear()
{
    timer = 0;
    length = 0;
    if (ev)
    {
	ev->stop();
	ev = 0;
    }
}

void Clock::tick(int inc)
{
    timer += inc;
}

void Clock::start()
{
    char buf[80];

    ASSERT(!ev);
    
    // create an event and start running in countup/100 seconds
    sprintf(buf, "A new game will start in %d seconds.", countup/100);
    message_all(buf);
    
    ev = new_game_event(Game_event::START, countdown);
    evl->add_event(ev, countup);
}

void Clock::stop()
{
    // remove our event and stop running
    if (ev)
    {
	ev->stop();
	ev = 0;
    }
}

void Clock::set_event(Game_event *_ev)
{
    // used to plan the next event.
    // take care: doesn't check overwriting of old events!

    ev = _ev;
}

Game_event *Clock::get_event()
{
    return ev;
}

unsigned int Clock::get_length()
{
    return length;
}

unsigned int Clock::get_timer()
{
    return timer;
}

Clock *new_clock(int length)
{
    Clock *cl;

    cl = (Clock *) new_object(SERVER_FREELIST_CLOCK);

    if (!cl)
    {
	cl = new Clock;
    }

    cl->set(length);
    return cl;
}
