/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       fire.cc
 *
 *       server functions related to shooting
 */

#include "globals.h"
#include "usercomm.h"
#include "math.h"
#include "message.h"

// fire at the specified coordinates
int do_fire_to(Splayer *pl, Packet_command *pc)
{
    Atom *a;
    Weapon *w;
    int ret;
    
    // check if the player has a weapon to fire
    // the player has to carry the weapon in their inventory
    w = pl->get_weapon();
    if (!w)
    {
	warning("do_fire_to: player doesn't have a weapon to fire");
	return 0;
    }

    // check if the target atom is valid
    a = lattice->get(pc->arg1, pc->arg2);
    if (!a)
    {
	warning("do_fire_to: invalid target coordinates [%d, %d]",
		pc->arg1, pc->arg2);
	return 0;
    }
    
    // fire the weapon
    ret = w->fire_to(a, pl);
    check_error_message(pl);

    return ret;
}

int do_fire_dir(Splayer *pl, Packet_command *pc)
{
    return 0;
}

int do_fire_at(Splayer *pl, Packet_command *pc)
{
    Electron *e;
    Weapon *w;
    int ret;

    warning("fire_at command");
    
    // check if the player has a weapon to fire
    // the player has to carry the weapon in their inventory
    w = pl->get_weapon();
    if (!w)
    {
	warning("do_fire_to: player doesn't have a weapon to fire");
	return 0;
    }

    // check if the target atom is valid
    e = storage->find(pc->arg1, pc->arg2);
    if (!e)
    {
	warning("do_fire_to: invalid target electron [%d, %d]",
		pc->arg1, pc->arg2);
	return 0;
    }

    warning("found target of type %s at %d, %d",
	    e->type_name, e->gx(), e->gy());
    
    // fire the weapon
    ret = w->fire_at(e, pl);
    check_error_message(pl);

    return ret;
}

// compute the distance between two atoms
double distance(Atom *a1, Atom *a2)
{
    int dx = a1->x - a2->x;
    int dy = a1->y - a2->y;

    return sqrt(dx * dx + dy * dy);
}

int do_lay_mine(Splayer *pl, Packet_command *pc)
{
    int ret;
    Vehicle *v;
    Shover *hov;

    // find the player's vehicle
    // for now only hover's can lay mines
    v = (Vehicle *)pl->get_vehicle();

    if (!v)
    {
	warning("Player tries to lay a mine but is not in a vehicle");
	message(pl, "You can only do that in a vehicle.");
	return 0;
    }

    if (v->actor_type != ACTOR_HOVER)
    {
	warning("Player tries to drop a mine with the wrong vehicle.");
	message(pl, "Your vehicle cannot lay mines.");
	return 0;
    }

    if (!pl->get_user()->is_owner(v))
    {
	message(pl, "You don't control that vehicle");
	return 0;
    }

    // all set? lay the mine.
    hov = (Shover *)v;
    ret = hov->lay_mine(pl);
    
    return ret;
}
